% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelDiffNet.R
\name{ModelDiffNet}
\alias{ModelDiffNet}
\alias{epiworld_diffnet}
\alias{plot.epiworld_diffnet}
\title{Network Diffusion Model}
\usage{
ModelDiffNet(
  name,
  prevalence,
  prob_adopt,
  normalize_exposure = TRUE,
  data = matrix(nrow = 0, ncol = 0),
  data_cols = 1L:ncol(data),
  params = vector("double")
)

\method{plot}{epiworld_diffnet}(x, main = get_name(x), ...)
}
\arguments{
\item{name}{Name of the model.}

\item{prevalence}{Prevalence of the disease.}

\item{prob_adopt}{Probability of adoption.}

\item{normalize_exposure}{Normalize exposure.}

\item{data}{Data.}

\item{data_cols}{Data columns.}

\item{params}{Parameters.}

\item{x}{Object of class \link{epiworld_diffnet}.}

\item{main}{Title of the plot}

\item{...}{Passed to \link[graphics:plot.default]{graphics::plot}.}
}
\value{
An object of class \link{epiworld_diffnet} and \link{epiworld_model}.
}
\description{
The network diffusion model is a simple model that assumes that
the probability of adoption of a behavior is proportional to the
number of adopters in the network.
}
\details{
Different from common epidemiological models, the network diffusion model
assumes that the probability of adoption of a behavior is proportional to the
number of adopters in the network. The model is defined by the following
equations:
\deqn{
P(adopt) = \mbox{Logit}^{-1}(prob\_adopt + params * data + exposure)
}
Where exposure is the number of adopters in the agent's network.

Another important difference is that the transmission network is not
necesary useful since adoption in this model is not from a particular
neighbor.
}
\examples{
set.seed(2223)
n <- 10000

# Generating synthetic data on a matrix with 2 columns.
X <- cbind(
  age = sample(1:100, n, replace = TRUE),
  female = sample.int(2, n, replace = TRUE) - 1
)

adopt_chatgpt <- ModelDiffNet(
  "ChatGPT",
  prevalence = .01,
  prob_adopt = .1,
  data       = X,
  params     = c(1, 4)
)

# Simulating a population from smallworld
agents_smallworld(adopt_chatgpt, n, 8, FALSE, .01)

# Running the model for 50 steps
run(adopt_chatgpt, 50)

# Plotting the model
plot(adopt_chatgpt)
}
\seealso{
Other Models: 
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
