% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition.R
\name{transition}
\alias{transition}
\title{Perform version transition of EnergyPlus model}
\usage{
transition(idf, ver, keep_all = FALSE, save = FALSE, dir = NULL)
}
\arguments{
\item{idf}{An \link{Idf} object or a path of IDF file.}

\item{ver}{A valid EnergyPlus IDD version, e.g. \code{9}, \code{8.8}, or \code{"8.8.0"}.}

\item{keep_all}{If \code{TRUE}, a list will be return which contains all
\link{Idf} objects of intermediate versions. The list will be named using first
two number of that version, e.g. \code{8.1}, \code{8.2}. If \code{FALSE}, only the \link{Idf}
object of the version specified by \code{ver} will be returned. Default: \code{FALSE}.}

\item{save}{If \code{TRUE}, the models will be saved into specified directory.
Default: \code{FALSE}.}

\item{dir}{Only applicable when \code{save} is \code{TRUE}. The directory to save the
new IDF files. If the directory does not exist, it will be created before
save. If \code{NULL}, the directory of input \link{Idf} object or IDF file will be
used. Default: \code{NULL}.}
}
\value{
An \link{Idf} object if \code{keep_all} is \code{FALSE} or a list of \link{Idf} objects
if \code{keep_all} is \code{TRUE}.
}
\description{
\code{transition()} takes an \link{Idf} object or a path of IDF file and a target
version, performs version transitions and returns an \link{Idf} object of
specified version.
}
\examples{
\dontrun{
if (any(avail_eplus()) > 7.2) {
    # create an empty IDF
    idf <- empty_idf(7.2)

    # convert it from v7.2 to the latest EnergyPlus installed
    transition(idf, max(avail_eplus()))

    # convert it from v7.2 to the latest EnergyPlus installed and keep all
    # intermediate versions
    transition(idf, max(avail_eplus()), keep_all = TRUE)

    # convert it from v7.2 to the latest EnergyPlus installed and keep all
    # intermediate versions and save all them
    idf$save(tempfile(fileext = ".idf"))
    transition(idf, max(avail_eplus()), keep_all = TRUE,
        save = TRUE, dir = tempdir()
    )
}
}
}
\seealso{
See \code{\link[=version_updater]{version_updater()}} which directly call EnergyPlus preprocessor
\code{IDFVersionUpdater} to perform the version transitions.
}
\author{
Hongyuan Jia
}
