% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{init_idf_value}
\alias{init_idf_value}
\title{Initialize value data}
\usage{
init_idf_value(
  idd_env,
  idf_env,
  class,
  field = NULL,
  property = NULL,
  underscore = FALSE,
  complete = FALSE,
  all = FALSE,
  default = TRUE,
  id = TRUE
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{class}{An integer vector of valid class indexes or a character vector
of valid class names. Default: \code{NULL}.}

\item{field}{An integer vector of valid field indexes or a character
vector of valid field names (can be in in underscore style). \code{class}
and \code{field} should have the same length.}

\item{property}{A character vector of column names in field table to return.}

\item{underscore}{If \code{TRUE}, input class name will be converted into
underscore style name first and column \code{class_name_us} will be used
for matching. Default: \code{FALSE}.}

\item{complete}{If \code{TRUE}, at least fields till the current whole extensible
group will be returned. A new column named "matched_rleid" will be
created (when \code{property} is NULL) indicating if given field has been
matched or not. Default: \code{FALSE}.}

\item{all}{If \code{TRUE}, all available fields defined in IDD for the class that
objects belong to will be returned. Default: \code{FALSE}.}

\item{default}{If \code{TRUE}, column \code{value_chr} and \code{value_num} will be filled
with default values. Default: \code{TRUE}.}

\item{id}{If \code{TRUE}, new value id will be added in column \code{value_id} based
on current existing value ids found in \code{idf_env}. Default: \code{TRUE}.}
}
\value{
A data.table containing specified columns.
}
\description{
Initialize value data
}
\note{
'object_id' and 'object_name' are added as all \code{NA}s.
}
\keyword{internal}
