% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{clean_wd}
\alias{clean_wd}
\title{Clean working directory of a previous EnergyPlus simulation}
\usage{
clean_wd(path)
}
\arguments{
\item{path}{An \code{.idf} or \code{.imf} file path.}
}
\description{
Clean working directory of an EnergyPlus simulation by deleting all input and
output files of previous simulation.
}
\details{
\code{clean_wd()} imitates the same process that EnergyPlus does whenever a new
simulation is getting to start. It deletes all related output files that
have the same name prefix as the input path. The input model itself and
any weather file are not deleted. \code{clean_wd()} is called internally when
running EnergyPlus models using \code{\link[=run_idf]{run_idf()}} and \code{\link[=run_multi]{run_multi()}}.
}
\examples{
\dontrun{
clean_wd("foo.idf")
}
}
\author{
Hongyuan Jia
}
