% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeNeuroTable.R
\name{createBaseTable}
\alias{createBaseTable}
\title{Create the final resulting data frame}
\usage{
createBaseTable(neurospace, atchashda, atchashsec, dneuromaxk)
}
\arguments{
\item{neurospace}{list of drug names that were aggregated using TopKLists::calculate.max topkspace}

\item{atchashda}{hashmap retrieved from readAtcMapIntoHashMapDrugNamesAtcCodes}

\item{atchashsec}{hashmap retrieved from readSecondLevelATC}

\item{dneuromaxk}{data frame containing columns for each intersection, ATC class, and reference list}
}
\value{
data frame containing drug names with additional columns listing association to ATC classes
}
\description{
Create the final resulting data frame
}
\examples{
utils::data(rawDrugBankCoOcEpSO, package="epos")
utils::data(rawDrugBankCoOcESSO, package="epos")
utils::data(rawDrugBankCoOcEPILONT, package="epos")
atchashda <-
readAtcMapIntoHashMapDrugNamesAtcCodes(
  system.file("extdata", "db-atc.map", package = "epos"), "\\t")
atchashaa <-
  readAtcMapIntoHashMapAtcCodesAtcNames(
    system.file("extdata", "db-atc.map", package = "epos"), "\\t")
atchashsec <-
  readSecondLevelATC(
    system.file("extdata", "drugbankatc-secondlevel.map", package = "epos"), "\\t")
tepso <- rawDrugBankCoOcEpSO
tesso <- rawDrugBankCoOcESSO
tepi <- rawDrugBankCoOcEPILONT
lepso <- genDictListFromRawFreq(tepso)
neuroepso <- filterNeuroDrugs(lepso, atchashda)
lesso <- genDictListFromRawFreq(tesso)
neuroesso <- filterNeuroDrugs(lesso, atchashda)
lepi <- genDictListFromRawFreq(tepi)
neuroepi <- filterNeuroDrugs(lepi, atchashda)
dneuro <-
  data.frame(EpSO = neuroepso[1:10],
             ESSO = neuroesso[1:10],
             EPILONT = neuroepi[1:10])
dneuromaxk <- TopKLists::calculate.maxK(dneuro, 3, 5, 10)
neurospace <- as.character(dneuromaxk$topkspace)
neurotable <-
  createBaseTable(neurospace, atchashda, atchashsec, dneuromaxk)
}
