% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqhpg.R
\name{hpg}
\alias{hpg}
\title{Calculate the Health Profile Grid}
\usage{
hpg(
  pre,
  post,
  country = NULL,
  version = NULL,
  type = NULL,
  ignore.invalid = TRUE,
  dimensions = .getDimensionNames(),
  no.problems = TRUE
)
}
\arguments{
\item{pre}{data.frame, numeric or character. For data.frame default column 
names should be MO, SC, UA, PD and AD representing Mobility, Self-care, 
Usual activities, Pain/discomfort and Anxiety/depression. Vector using five 
digit format can also be used.}

\item{post}{data.frame, numeric or character. For data.frame default column 
names should be MO, SC, UA, PD and AD representing Mobility, Self-care, 
Usual activities, Pain/discomfort and Anxiety/depression. Vector using five 
digit format can also be used.}

\item{country}{string of value set country name used.}

\item{version}{string of value "3L" or "5L" to indicate instrument version.}

\item{type}{string specifying method type used in deriving value set scores.
Options are TTO or VAS for EQ-5D-3L, VT for EQ-5D-5L, CW for EQ-5D-5L
crosswalk conversion valuesets, RCW for EQ-5D-3L reverse crosswalk
conversion valuesets.}

\item{ignore.invalid}{boolean whether to ignore invalid scores. TRUE returns NA, FALSE 
throws an error.}

\item{dimensions}{character vector, specifying "dimension" column names. Defaults 
are "MO", "SC", "UA", "PD" and "AD".}

\item{no.problems}{boolean. Summarise 11111 "No change" subjects in a "No problems" 
group.}
}
\value{
a data.frame or list of data.frames containing the columns Pre, Post and PCHC. 
Pre and Post contain the severity rankings and PCHC the PCHC category.
}
\description{
Calculate the Health Profile Grid (HPG) for two EQ-5D datasets.
}
\examples{
dat <- read.csv(system.file("extdata", "eq5d3l_example.csv", package="eq5d"))

pre <- dat[dat$Group=="Group1",][1:50,]
post <- dat[dat$Group=="Group2",][1:50,]
res <- hpg(pre, post, country="UK", version="3L", type="TTO")
head(res)

}
