\name{error}
\alias{bootstrap}
\alias{bootstrap.default}
\alias{bootstrap.equate}
\alias{bootstrap.freqtab}
\alias{as.bootstrap}
\alias{is.bootstrap}
\alias{summary.bootstrap}
\alias{lnse}
\alias{eqse}
\title{Bootstrap Equating Error}
\description{
These functions return bootstrap standard errors, bias, and RMSE of equating.
}
\usage{
\method{bootstrap}{default}(x, y, ...)

\method{bootstrap}{equate}(x, xp = x$x, yp = x$y, ...)

\method{bootstrap}{freqtab}(x, y, xn = sum(x),
	yn = sum(y), reps = 100, crit, args,
	eqs = FALSE, ...)
	
\method{summary}{bootstrap}(object, weights, subset, ...)
}
\arguments{
  \item{x}{
either an equating object, obtained with the \code{\link{equate}} function, or a score distribution of class \dQuote{\code{\link{freqtab}}}.
}
  \item{xp, yp}{
optional frequency tables replacing those equated in \code{x}, used for parametric bootsampling.
}
  \item{y}{
score distribution of class \dQuote{\code{\link{freqtab}}}.
}
  \item{xn, yn}{
integers specifying the number of scores to sample from each distribution at each replication (default is the total number observed in each).
}
  \item{reps}{
number of bootstrap replications.
}
  \item{crit}{
vector of equated scores serving as the criterion equating function when calculating bootstrap bias and RMSE, both of which are returned when \code{crit} is specified.
}
  \item{args}{
named list of equating arguments, passed to \code{\link{equate}}, specifying, e.g., the equating type and method. See below for details.
}
  \item{eqs}{
logical, with default \code{FALSE}, indicating whether or not the matrices of equating functions (one column per replication, per equating) should be returned.
}
  \item{object}{
\code{bootstrap} output to be summarized.
}
  \item{weights}{
vector of weights to be used in calculating weighted average errors with \code{summary}, defaulting to the frequencies in \code{margin(object$x)}.
}
  \item{subset}{
vector indicating a subset of the score scale for which errors should be summarized.
}
  \item{\dots}{
further arguments passed to or from other methods.
}
}
\details{
Samples are drawn of size \code{xn} and \code{yn}, with replacement, from each score distribution. Form Y equivalents of each form X score are then obtained using either the arguments in the equating output or those provided. This process is repeated \code{reps} times. Standard errors are calculated as standard deviations over replications for each score point; bias is the mean equated score over replications, minus the criterion; and RMSE is the square root of the squared standard error and squared bias combined.

The bootstrap method for objects of class \dQuote{\code{equate}} is designed to be called from within \code{\link{equate}}. It simply extracts the necessary arguments from the equating output before bootstrapping.

When each element in \code{args} is a named list of equating arguments, multiple equatings are performed at each replication in the bootstrapping.

The summary method returns a \code{data.frame} of mean standard errors, bias, and rmse, and weighted and absolute means, as applicable.
}
\value{
A list is returned, containing arguments supplied for \code{x}, \code{y}, \code{reps}, \code{xn}, \code{yn}, and \code{args}. For a single equating, the \code{mean} equating function over replications and a vector of standard errors \code{se} are included, along with vectors of \code{bias} and \code{rmse}, when \code{crit} is provided, and a matrix of equating functions \code{eqs} when \code{eqs = TRUE}. For multiple equatings, where each element of \code{args} is a list of equating arguments, matrices are returned for the mean functions, standard error, bias, and RMSE, and the equating functions will be returned as a list of matrices.
}
\author{
Anthony Albano \email{tony.d.albano@gmail.com}
}
\seealso{
\code{\link{plot.bootstrap}}
}
\examples{
# Parametric bootstrapping using smoothed
# frequency distributions
set.seed(111213)
x <- freqtab(KBneat$x, scales = list(0:36, 0:12))
y <- freqtab(KBneat$y, scales = list(0:36, 0:12))
xp <- loglinear(x, asfreqtab = TRUE)
yp <- loglinear(y, asfreqtab = TRUE)
crit <- equate(xp, yp, "e", "c")$conc$yx
eqargs <- list(m.t = list(type = "m", method = "t"),
  l.t = list(type = "l", method = "t"))
bootout1 <- bootstrap(x = x, y = y, xn = 100, yn = 100,
  crit = crit, args = eqargs, reps = 30)
plot(bootout1, out = "rmse", legendplace = "top",
  addident = FALSE)

# Bootstraps for an existing equating
eq <- equate(x, y, type = "m", method = "t")
bootout2 <- bootstrap(eq, xn = 100, yn = 100,
  crit = crit, reps = 30)
}
\keyword{methods}