% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-era.R
\name{eras}
\alias{eras}
\title{Standard era definitions}
\usage{
eras(label = NA)
}
\arguments{
\item{label}{(Optional) Abbreviated names(s) of eras to look up.}
}
\value{
A table of era definitions. This can be passed to \code{\link[=era]{era()}} to construct an
\code{era} object.
}
\description{
Definitions of common eras and time scales.

\code{eras()} lists all available era definitions. \code{eras(label)} looks up a
specific era by its unique, abbreviated name (e.g. "cal BP").
}
\details{
Looking up eras by \code{label} uses partial matching.
}
\examples{
# List all available eras
eras()

# Look up a specific era by label
eras("cal BP")

# With partial matching
eras("cal")
}
\seealso{
Other era definition functions: 
\code{\link{era}}
}
\concept{era definition functions}
