% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eratosthenes.R
\name{synth_rank}
\alias{synth_rank}
\alias{synth_rank.list}
\title{Synthetic Ranking}
\usage{
synth_rank(obj, ties = "average")

\method{synth_rank}{list}(obj, ties = "average")
}
\arguments{
\item{obj}{A \code{list} of \code{vector} objects which reperesent a sequence.}

\item{ties}{The way in which ties are handled per the \code{\link{rank}} function. The default is \code{"ties = average"}.}
}
\value{
A single vector containing the synthesized ranking.
}
\description{
Using a \code{list} two or more partial sequences, all of which observe the same order of elements, create a single "synthetic" ranking. This is accomplished by counting the total number of elements after running a recursive trace through all partial sequences (via \code{\link[eratosthenes]{quae_postea}}). If partial sequences are inconsistent in their rankings, a \code{NULL} value is returned.
}
\examples{
x <- c("A", "B", "C", "D", "E")
y <- c("B", "D", "F", "E")
a <- list(x, y)

synth_rank(a)

}
