% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreedist.R
\name{degreedist.egor}
\alias{degreedist.egor}
\alias{degreedist}
\title{Plotting the degree distribution of an egocentric dataset}
\usage{
\method{degreedist}{egor}(
  object,
  freq = FALSE,
  prob = !freq,
  by = NULL,
  brgmod = FALSE,
  main = NULL,
  plot = brgmod,
  weight = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{\link{egor}} object.}

\item{freq, prob}{Whether to plot the raw frequencies or the conditional
proportions of the degree values. Defaults to the latter.}

\item{by}{A character vector giving the name of a vertex attribute; if
given, plots the frequences broken down by that attribute.}

\item{brgmod}{Plot the range of predicted frequencies/probabilities
according to a Bernoulli graph having the same expected density as the
observed.}

\item{main}{Main title of the plot.}

\item{plot}{Whether to plot the histogram; defaults to the same
value as\code{brgmod}, i.e., \code{FALSE}.}

\item{weight}{Whether sampling weights should be incorporated into
the calculation (\code{TRUE}, the default) or ignored (\code{FALSE}).}

\item{...}{Additional arguments to \code{\link[=simulate.ergm.ego]{simulate.ergm.ego()}}.}
}
\value{
Returns either a vector of degree frequencies/proportions
if \code{by=NULL} or a matrix with a row for each category if not. If
\code{plot==TRUE} returns invisibly.
}
\description{
A \code{\link[=degreedist]{degreedist()}} method for \code{\link{egodata}} objects: plot a histogram
of the degree distribution of actors in the egocentric dataset,
optionally broken down by group and/or compared with a Bernoulli
graph.
}
\examples{

data(faux.mesa.high)
fmh.ego <- as.egor(faux.mesa.high)

degreedist(fmh.ego,by="Grade",brgmod=TRUE)
# Compare:
degreedist(faux.mesa.high)

}
\seealso{
\code{\link{degreedist}},
\code{\link[ergm:summary_formula]{summary}}
}
