% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EgoStat.node.attr.R
\name{nodal_attributes-API}
\alias{nodal_attributes-API}
\alias{ergm.ego_get_vattr}
\alias{ergm.ego_get_vattr.character}
\alias{ergm.ego_get_vattr.function}
\alias{ergm.ego_get_vattr.formula}
\alias{ergm.ego_attr_levels}
\alias{ergm.ego_attr_levels.numeric}
\alias{ergm.ego_attr_levels.logical}
\alias{ergm.ego_attr_levels.AsIs}
\alias{ergm.ego_attr_levels.character}
\alias{ergm.ego_attr_levels.NULL}
\alias{ergm.ego_attr_levels.matrix}
\alias{ergm.ego_attr_levels.function}
\alias{ergm.ego_attr_levels.formula}
\alias{COLLAPSE_SMALLEST}
\title{Helper functions for specifying nodal attribute levels}
\usage{
ergm.ego_get_vattr(
  object,
  df,
  accept = "character",
  multiple = if (accept == "character") "paste" else "stop",
  ...
)

\method{ergm.ego_get_vattr}{character}(
  object,
  df,
  accept = "character",
  multiple = if (accept == "character") "paste" else "stop",
  ...
)

\method{ergm.ego_get_vattr}{`function`}(
  object,
  df,
  accept = "character",
  multiple = if (accept == "character") "paste" else "stop",
  ...
)

\method{ergm.ego_get_vattr}{formula}(
  object,
  df,
  accept = "character",
  multiple = if (accept == "character") "paste" else "stop",
  ...
)

ergm.ego_attr_levels(object, attr, egor, levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{numeric}(object, attr, egor, levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{logical}(object, attr, egor, levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{AsIs}(object, attr, egor, levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{character}(object, attr, egor, levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{`NULL`}(object, attr, egor, levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{matrix}(object, attr, egor, levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{`function`}(object, attr, egor, levels = sort(unique(attr)), ...)

\method{ergm.ego_attr_levels}{formula}(object, attr, egor, levels = sort(unique(attr)), ...)

COLLAPSE_SMALLEST(object, n, into)
}
\arguments{
\item{object}{An argument specifying the nodal attribute to select
or which levels to include.}

\item{df}{Table of egos or of alters.}

\item{accept}{A character vector listing permitted data types for
the output. See the Details section for the specification.}

\item{multiple}{Handling of multiple attributes or matrix or data
frame output. See the Details section for the specification.}

\item{...}{Additional argument to the functions of network or to
the formula's environment.}

\item{attr}{A vector of length equal to the number of nodes,
specifying the attribute vector.}

\item{egor}{An \code{\link[egor:egor]{egor}} object.}

\item{levels}{Starting set of levels to use; defaults to the sorted
list of unique attributes.}

\item{n, into}{see \code{\link[ergm:nodal_attributes]{ergm::COLLAPSE_SMALLEST()}}.}
}
\value{
\code{ergm.ego_get_vattr} returns a vector of length equal to the
number of nodes giving the selected attribute function or, if
\code{multiple="matrix"}, a matrix whose number of row equals the
number of nodes. Either may also have an attribute \code{"name"}, which
controls the suggested name of the attribute combination.

\code{ergm.ego_attr_levels} returns a vector of levels to use and their order.
}
\description{
These functions are meant to be used in \code{EgoStat} and other
implementations to provide the user with a way to extract nodal attributes
and select their levels in standardized and flexible ways. They are
intended to parallel \code{\link[ergm:nodal_attributes-API]{ergm::nodal_attributes-API}}.

\code{ergm.ego_get_vattr} extracts and processes the specified
nodal attribute vector. It is strongly recommended that
\code{\link[ergm:check.ErgmTerm]{check.ErgmTerm()}}'s corresponding
\code{vartype="function,formula,character"} (using the
\code{ERGM_VATTR_SPEC} constant).

\code{ergm.ego_attr_levels} filters the levels of the
attribute.  It is strongly recommended that \code{\link[ergm:check.ErgmTerm]{check.ErgmTerm()}}'s
corresponding
\code{vartype="function,formula,character,numeric,logical,AsIs,NULL"} (using the
\code{ERGM_LEVELS_SPEC} constant).
}
\details{
The \code{accept} argument is meant to allow the user to
quickly check whether the output is of an \emph{acceptable} class or
mode. Typically, if a term accepts a character (i.e.,
categorical) attribute, it will also accept a numeric one,
treating each number as a category label. For this reason, the
following outputs are defined:
\describe{

\item{\code{"character"}}{Accept any mode or class (since it can
be converted to character).}

\item{\code{"numeric"}}{Accept real, integer, or logical.}

\item{\code{"logical"}}{Accept logical.}

\item{\code{"integer"}}{Accept integer or logical.}

\item{\code{"natural"}}{Accept a strictly positive integer.}

\item{\code{"0natural"}}{Accept a nonnegative integer or logical.}

\item{\code{"nonnegative"}}{Accept a nonnegative number or logical.}

\item{\code{"positive"}}{Accept a strictly positive number or logical.}

\item{\code{"index"}}{Mentioned here for completeness, it does not make
sense for egocentric data (since networks are constructed) and so
is not supported.}

}

Given that, the \code{multiple} argument controls how passing multiple
attributes or functions that result in vectors of appropriate
dimension are handled: \describe{

\item{\code{"paste"}}{Paste together with dot as the separator.}

\item{\code{"stop"}}{Fail with an error message.}

\item{\code{"matrix"}}{Construct and/or return a matrix whose rows correspond to vertices.}

}
}
\section{Functions}{
\itemize{
\item \code{COLLAPSE_SMALLEST()}: A version of \code{\link[ergm:nodal_attributes]{ergm::COLLAPSE_SMALLEST()}} that can handle both \code{\link[network:network]{network}} and \code{\link{egodata}} objects.

}}
\note{
\code{ergm.ego_attr_levels.matrix()} expects \verb{levels=} to be a
\code{\link{list}} with each element having length 2 and containing the
values of the two categorical attributes being crossed. It also
assumes that they are in the same order as the user would like
them in the matrix.
}
\examples{
data(florentine)
flomego <- as.egor(flomarriage)
ergm.ego_get_vattr("priorates", flomego)
ergm.ego_get_vattr(~priorates, flomego)
ergm.ego_get_vattr(~cbind(priorates, priorates^2), flomego, multiple="matrix")
ergm.ego_get_vattr(c("wealth","priorates"), flomego)
ergm.ego_get_vattr(c("wealth","priorates"), flomego, multiple="matrix")
ergm.ego_get_vattr(~priorates>30, flomego)
(a <- ergm.ego_get_vattr(~cut(priorates,c(-Inf,0,20,40,60,Inf),label=FALSE)-1, flomego))
ergm.ego_attr_levels(NULL, a, flomego)
ergm.ego_attr_levels(-1, a, flomego)
ergm.ego_attr_levels(1:2, a, flomego)
ergm.ego_attr_levels(I(1:2), a, flomego)
}
\keyword{internal}
