% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.node.attr.R
\name{node-attr}
\alias{node-attr}
\alias{attrname}
\alias{on}
\alias{by}
\alias{attrs}
\title{Specifying nodal attributes and their levels}
\description{
This document describes the ways in which to specify
nodal attribute or functions and which levels for categorical
factors to include. For the helper functions to facilitate this,
see \code{\link{node-attr-api}}.
}
\details{
Term nodal attribute arguments, typically called \code{attrs}, \code{attrname}, \code{by},
\code{on}, etc. are interpreted as follows: \describe{

\item{a single character string}{Extract the vertex attribute with
this name.}

\item{a character vector of length > 1}{Extract the vertex
attributes and paste them together, separated by dots.}

\item{a function}{The function is called on the LHS network,
expected to return a vector of appropriate length. (Shorter vectors
will be recycled as needed.)}

\item{a formula}{The expression on the RHS of the formula is
evaluated in an environment of the vertex attributes of the
network, expected to return a vector of appropriate
length. (Shorter vectors will be recycled as needed.) Within this
expression, the network itself accessible as either \code{.} or
\code{.nw}. For example,
\code{nodecov(~abs(Grade-mean(Grade))/network.size(.))} would return the
absolute difference of each actor's "Grade" attribute from its
network-wide mean, divided by the network size.}

}

For categorical attributes, to select which levels are of interest
and their ordering, use the argument \code{levels}.  It is interpreted
as follows: \describe{

\item{an expression wrapped in \code{\link[=I]{I()}}}{Use the given list of levels
as is.}

\item{a numeric or logical vector}{Used for indexing of the default
set of levels (typically, unique values of the attribute) in
default older (typically lexicographic), i.e.,
\code{sort(unique(attr))[levels]}. Negative values exclude. To specify
numeric or logical levels literally, wrap in \code{\link[=I]{I()}}.}

\item{a character vector}{Use as is.}

\item{a function}{The function is called on the list of unique
values of the attribute, the values of the attribute themselves,
and the network itself, depending on its arity. Its return value is
interpreted as above.}

\item{a formula}{The expression on the RHS of the formula is
evaluated in an environment in which the network itself is
accessible as \code{.nw}, the list of unique values of the attribute as
\code{.} or as \code{.levels}, and the attribute vector itself as
\code{.attr}. Its return value is interpreted as above.}

}

Note that \code{levels} often has a default that is sensible for the
term in question.
}
\examples{

data(faux.mesa.high)
# Mixing between lower and upper grades:
summary(faux.mesa.high~mm(~Grade>=10))
# Mixing between grades 7 and 8 only:
summary(faux.mesa.high~mm("Grade", levels=I(c(7,8))))
# or
summary(faux.mesa.high~mm("Grade", levels=1:2))
# or using levels2 (see ? mm) to filter the combinations of levels,
summary(faux.mesa.high~mm("Grade",
        levels2=~sapply(.levels,
                        function(l)
                          l[[1]]\%in\%c(7,8) && l[[2]]\%in\%c(7,8))))
}
