% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{err_wrappers}
\alias{err_wrappers}
\alias{cc_and}
\alias{cc_or}
\alias{co_and}
\alias{co_or}
\title{Wrappers with Conjunction and '' Brackets.}
\usage{
cc_and(object)

cc_or(object)

co_and(object, one = "\%o has \%n value\%s: \%c",
  object_name = substitute(object))

co_or(object, one = "\%o has \%n value\%s: \%c",
  object_name = substitute(object))
}
\arguments{
\item{object}{The object with values to concatenate.}

\item{one}{The string to return if \code{n = 1}}

\item{object_name}{A string of the object name.}
}
\description{
Wrappers with Conjunction and '' Brackets.
}
\section{Functions}{
\itemize{
\item \code{cc_and}: Concatenation with Commas and And Conjunction

\item \code{cc_or}: Concatenation with Commas and Or Conjunction

\item \code{co_and}: Customizable Object Aware String and And Conjunction

\item \code{co_or}: Customizable Object Aware String and Or Conjunction
}}

\examples{
cc_and(1:100)
cc_or(100:1)
co_and(1:100)
co_or(100:1)
}
\seealso{
\code{\link{cc}} and \code{\link{co}}
}
