% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issue.R
\name{Issue}
\alias{Issue}
\title{Core Class}
\description{
Core class to create and handle issues.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{rule}}{Rules to perform checks, must be functions that
accept a single argument and return a boolean.}

\item{\code{message}}{The message (warning or error).}

\item{\code{call}}{Expression or function (as string) that led
to the issue.}

\item{\code{raiser}}{Function to run when the \code{raise} method
is called. By default the error uses \code{stop()} and warning
uses \code{warning()}. The function must accept a single argument:
the error message (character vector).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Issue$new()}}
\item \href{#method-print}{\code{Issue$print()}}
\item \href{#method-return}{\code{Issue$return()}}
\item \href{#method-addRule}{\code{Issue$addRule()}}
\item \href{#method-check}{\code{Issue$check()}}
\item \href{#method-raise}{\code{Issue$raise()}}
\item \href{#method-clone}{\code{Issue$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Issue$new(obj, type = c("error", "warning"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{A character string or an object of
class \code{error}, or \code{warning}.}

\item{\code{type}}{Type of message.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Issue$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print

Print message of error or warning.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-return"></a>}}
\if{latex}{\out{\hypertarget{method-return}{}}}
\subsection{Method \code{return()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Issue$return(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{the number of generations to go back, passed to
\code{\link[=parent.frame]{parent.frame()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Return
Returns self from parent function.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addRule"></a>}}
\if{latex}{\out{\hypertarget{method-addRule}{}}}
\subsection{Method \code{addRule()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Issue$addRule(fn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Function defining rule, must accept a single argument
and return a boolean.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Add a rule
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check"></a>}}
\if{latex}{\out{\hypertarget{method-check}{}}}
\subsection{Method \code{check()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Issue$check(obj)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{Object to check by rules}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Add a predicate
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-raise"></a>}}
\if{latex}{\out{\hypertarget{method-raise}{}}}
\subsection{Method \code{raise()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Issue$raise(fn = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{A function to use to raise the issue.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Raise error or warning
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Issue$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
