% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_mip.R
\name{inspect_mip}
\alias{inspect_mip}
\title{inspect the mip problem formulation for one record}
\usage{
inspect_mip(data, x, weight, ...)
}
\arguments{
\item{data}{data to be checked}

\item{x}{validation rules or errorlocalizer object to be used for finding
possible errors.}

\item{weight}{\code{numeric} optional weight vector to be used in the error localization.}

\item{...}{optional parameters that are passed to \code{\link[lpSolveAPI:lp.control]{lpSolveAPI::lp.control()}} (see details)}
}
\description{
Utility function to inspect the mip problem for a record.
}
\details{
It may sometimes be handy to find out what is happening exactly with a record.
See the example section for finding out what to do with inspect_mip.
}
\examples{
rules <- validator(x > 1)
data <- list(x = 0)
weight <- c(x = 1)

mip <- inspect_mip(data, rules)
print(mip)

# inspect the lp problem (prior to solving it with lpsolveAPI)
lp <- mip$to_lp()
print(lp)

# for large problems write the lp problem to disk for inspection
# lpSolveAPI::write.lp(lp, "my_problem.lp")

# solve the mip system / find a solution
res <- mip$execute()
names(res)

# lpSolveAPI status of finding a solution
res$s

# lp problem after solving (often simplified version of first lp)
res$lp

# records that are deemed "faulty"
res$errors

# values of variables used in the mip formulation. Also contains a valid solution
# for "faulty" variables
res$values

# see the derived mip rules and objective function, used in the construction of
# lp problem
mip$mip_rules()
mip$objective
}
\seealso{
Other Mixed Integer Problem: 
\code{\link{MipRules-class}}
}
\concept{Mixed Integer Problem}
