% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_t.R
\name{esc_t}
\alias{esc_t}
\title{Compute effect size from Student's t-test}
\usage{
esc_t(t, p, totaln, grp1n, grp2n, es.type = c("d", "g", "or", "logit",
  "r", "f", "eta", "cox.or", "cox.log"), study = NULL, ...)
}
\arguments{
\item{t}{The t-value of the t-test. One of \code{t} or \code{p} must be specified.}

\item{p}{The p-value of the t-test. One of \code{t} or \code{p} must be specified.}

\item{totaln}{Total sample size. Either \code{totaln}, or \code{grp1n} and
\code{grp2n} must be specified.}

\item{grp1n}{Treatment group sample size.}

\item{grp2n}{Control group sample size.}

\item{es.type}{Type of effect size that should be returned.
\describe{
  \item{\code{"d"}}{returns standardized mean difference effect size \code{d}}
  \item{\code{"f"}}{returns effect size Cohen's \code{f}}
  \item{\code{"g"}}{returns adjusted standardized mean difference effect size Hedges' \code{g}}
  \item{\code{"or"}}{returns effect size as odds ratio}
  \item{\code{"cox.or"}}{returns effect size as Cox-odds ratio (see \code{\link{convert_d2or}} for details)}
  \item{\code{"logit"}}{returns effect size as log odds}
  \item{\code{"cox.log"}}{returns effect size as Cox-log odds (see \code{\link{convert_d2logit}} for details)}
  \item{\code{"r"}}{returns correlation effect size \code{r}}
  \item{\code{"eta"}}{returns effect size eta squared}
}}

\item{study}{Optional string with the study name. Using \code{\link{combine_esc}} or
\code{as.data.frame} on \code{esc}-objects will add this as column
in the returned data frame.}

\item{...}{Other parameters, passed down to further functions. For internal
use only, can be ignored.}
}
\value{
The effect size \code{es}, the standard error \code{se}, the variance
        of the effect size \code{var}, the lower and upper confidence limits
        \code{ci.lo} and \code{ci.hi}, the weight factor \code{w} and the
        total sample size \code{totaln}.
}
\description{
Compute effect size from Student's t-test for \emph{independent samples}.
}
\note{
This function only applies to \emph{independent sample} t-tests, either
      equal or unequal sample sizes. It can't be used for t-values from
      dependent or paired t-tests, or t-values from other statistical procedures
      (like regressions).
      \cr \cr
      If \code{es.type = "r"}, Fisher's transformation for the effect size
      \code{r} and their confidence intervals are also returned.
}
\examples{
# unequal sample size
esc_t(t = 3.3, grp1n = 100, grp2n = 150)

# equal sample size
esc_t(t = 3.3, totaln = 200)

# unequal sample size, with p-value
esc_t(p = 0.03, grp1n = 100, grp2n = 150)

# equal sample size, with p-value
esc_t(p = 0.03, totaln = 200)

}
\references{
Lipsey MW, Wilson DB. 2001. Practical meta-analysis. Thousand Oaks, Calif: Sage Publications
            \cr \cr
            Wilson DB. 2016. Formulas Used by the "Practical Meta-Analysis Effect Size Calculator". Unpublished manuscript: George Mason University
}
