% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_convert.R
\name{spatial_convert}
\alias{spatial_convert}
\title{Convert coordinates between reference systems}
\usage{
spatial_convert(data, to)
}
\arguments{
\item{data}{\code{Numeric} vector of length two or data frame, 
x-, y-coordinates to be converted.}

\item{to}{\code{Character} value, proj4 string of the output 
reference system.}
}
\value{
\code{Numeric} data frame with converted coordinates.
}
\description{
Coordinates are converted between reference systems.
}
\examples{

## create lat lon coordinates
xy <- c(13, 55)

## define output coordinate system 
proj_out <- "+proj=utm +zone=32 +datum=WGS84"

## convert coordinate pair
spatial_convert(data = xy, 
                to = proj_out)
                
## define set of coordinates
xy <- data.frame(x = c(10, 11),
                 y = c(54, 55))
                 
## convert set of coordinates
spatial_convert(data = xy, 
                to = proj_out)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
