% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-coerce.R
\name{module-coerce}
\alias{module-coerce}
\alias{coerceUI}
\alias{coerceServer}
\title{Coerce data.frame's columns module}
\usage{
coerceUI(id)

coerceServer(input, output, session, data, reactiveValuesSlot = "data")
}
\arguments{
\item{id}{Module id. See \code{\link[shiny]{callModule}}.}

\item{input, output, session}{standards \code{shiny} server arguments.²}

\item{data}{A \code{data.frame} or a \code{reactive}
function returning a \code{data.frame} or a 
\code{reactivevalues} with a slot containing a \code{data.frame} 
(use \code{reactiveValuesSlot} to identify that slot)}

\item{reactiveValuesSlot}{If \code{data} is a \code{reactivevalues}, 
specify the name of the slot containing data.}
}
\value{
a \code{reactiveValues} with two slots: \code{data} original \code{data.frame}
 with modified columns, and \code{names} column's names with call to coerce method.
}
\description{
Coerce data.frame's columns module
}
\examples{

if (interactive()) {
  library(esquisse)
  library(shiny)
  
  foo <- data.frame(
    num_as_char = as.character(1:10),
    char = sample(letters[1:3], 10, TRUE),
    fact = factor(sample(LETTERS[1:3], 10, TRUE)),
    date_as_char =  as.character(
      Sys.Date() + sample(seq(-10, 10), 10, TRUE)
    ),
    date_as_num = as.numeric(
      Sys.Date() + sample(seq(-10, 10), 10, TRUE)
    ),
    datetime = Sys.time() + sample(seq(-10, 10) * 1e4, 10, TRUE), 
    stringsAsFactors = FALSE
  )
  
  ui <- fluidPage(
    tags$h2("Coerce module"),
    fluidRow(
      column(
        width = 4,
        coerceUI(id = "example")
      ),
      column(
        width = 8,
        verbatimTextOutput(outputId = "print_result"),
        verbatimTextOutput(outputId = "print_names")
      )
    )
  )
  
  server <- function(input, output, session) {
    
    result <- callModule(module = coerceServer, id = "example", data = reactive({foo}))
    
    output$print_result <- renderPrint({
      str(result$data)
    })
    output$print_names <- renderPrint({
      result$names
    })
  }
  
  shinyApp(ui, server)
}

}
