% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_any_rounds.R
\name{show_rounds_country}
\alias{show_rounds_country}
\title{Return countries that participated in \strong{all} of the specified rounds.}
\usage{
show_rounds_country(rounds, participate = TRUE)
}
\arguments{
\item{rounds}{A numeric vector specifying the rounds from which to return the countries.
Use \code{\link{show_rounds}}for a list of available rounds.}

\item{participate}{A logical that controls whether to show participating countries in that/those
rounds or countries that didn't participate. Set to \code{TRUE} by default.}
}
\value{
A character vector with the country names
}
\description{
Return countries that participated in \strong{all} of the specified rounds.
}
\details{
\code{show_rounds_country} returns the countries that participated in
\strong{all} of the specified rounds. That is, \code{show_rounds_country(1:2)}
will return countries that participated both in round 1 and round 2. Conversely,
if \code{participate = FALSE} it will return the countries that did not
participate in \strong{both} round 1 and round 2.
}
\examples{

\dontrun{

# Return countries that participated in round 2

show_rounds_country(2)

# Return countries that participated in all rounds

show_rounds_country(1:8)

# Return countries that didn't participate in the first three rounds

show_rounds_country(1:3, participate = FALSE)

}
}
