% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric_tests.R
\name{parametric_tests}
\alias{parametric_tests}
\title{Returns the result of given event study parametric tests.}
\usage{
parametric_tests(list_of_returns, event_start, event_end, all = TRUE, tests)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}

\item{all}{a logical vector of length one indicating whether all tests should
be performed. The default value is \code{TRUE}.}

\item{tests}{a list of tests' functions among \code{brown_warner_1980},
\code{brown_warner_1985}, \code{t_test}, \code{patell}, \code{boehmer}, and
\code{lamb}.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{date}: a calendar date
    \item \code{weekday}: a day of the week
    \item \code{percentage}: a share of non-missing observations for a given
          day
    \item \code{mean}: an average abnormal return
    \item Various tests' statistics and significance
}
}
\description{
Performs main parametric tests for each date in the event window and returns
a data frame of their statistics and significance.
}
\details{
\code{parametric_tests} performs given tests among \code{brown_warner_1980},
\code{brown_warner_1985}, \code{t_test}, \code{patell}, \code{boehmer},
\code{lamb} and merge result to a single data frame. If \code{all = TRUE}
(the default value), the function ignores the value of \code{tests}.
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^N100",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "TOP.CO")
nine_eleven_param <- get_prices_from_tickers(tickers,
                                             start = as.Date("2000-01-01"),
                                             end = as.Date("2002-01-01"),
                                             quote = "Close",
                                             retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    parametric_tests(event_start = as.Date("2001-09-11"),
                     event_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
nine_eleven_param <- parametric_tests(list_of_returns = securities_returns,
                                      event_start = as.Date("2001-09-11"),
                                      event_end = as.Date("2001-09-28"))

}
\references{
\itemize{
\item Brown S.J., Warner J.B. \emph{Measuring security price performance}.
Journal of Financial Economics, 8:205-258, 1980.
\item Brown S.J., Warner J.B. \emph{Using Daily Stock Returns, The Case of
Event Studies}. Journal of Financial Economics, 14:3-31, 1985.
\item Boehmer E., Musumeci J., Poulsen A.B. \emph{Event-study methodology
under conditions of event-induced variance}. Journal of Financial Economics,
30(2):253-272, 1991.
\item Patell J.M. \emph{Corporate forecasts of earnings per share and stock
price behavior: empirical tests}. Journal of Accounting Research, 14(2):246-
276, 1976.
\item Lamb R.P. \emph{An Exposure-Based Analysis of Property-Liability
Insurer Stock Values around Hurricane Andrew}. Journal of Risk and Insurance,
62(1):111-123, 1995.}
}
\seealso{
\code{\link{brown_warner_1980}}, \code{\link{brown_warner_1985}},
\code{\link{t_test}}, \code{\link{patell}}, \code{\link{boehmer}}, and
\code{\link{lamb}}.
}
