% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_calcs.R
\name{auc}
\alias{auc}
\title{Calculate the area under the curve}
\usage{
auc(formula, data, ref_group = NULL, tidy = TRUE)
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{ref_group}{Optional. If the name of the reference group is provided
(must be character and match the grouping level exactly), only the
estimates corresponding to the given reference group will be returned.}

\item{tidy}{Logical. Should the data be returned in a tidy data frame? (see
\href{https://www.jstatsoft.org/article/view/v059i10}{Wickham, 2014}). If
 false, effect sizes returned as a vector.}
}
\value{
By default the area under the curve for all possible pairings of
the grouping factor are returned as a tidy data frame. Alternatively, a 
vector can be returned, and/or only the auc corresponding to a specific
reference group can be returned.
}
\description{
This function is used within \code{\link{pp_plot}} to calculate the area 
under the \code{pp} curve. The area under the curve is also a useful 
effect-size like statistic, representing the probability that a randomly 
selected individual from distribution a will have a higher value than a 
randomly selected individual from distribution b.
}
\examples{
free_reduced <- rnorm(800, 80, 20)
pay <- rnorm(500, 100, 10)
d <- data.frame(score = c(free_reduced, pay), 
				frl = c(rep("free_reduced", 800),  
						rep("pay", 500)))

auc(score ~ frl, d)
# Compute AUC for all pairwise comparisons
auc(reading ~ condition, star)

# Specify regular-sized classrooms as the reference group
auc(reading ~ condition, 
		star, 
		ref_group = "reg")

# Return a vector instead of a data frame
auc(reading ~ condition, 
		star, 
		ref_group = "reg", 
		tidy = FALSE)
}
