% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binned_es_plot.R
\name{binned_plot}
\alias{binned_plot}
\title{Quantile-binned effect size plot}
\usage{
binned_plot(
  data,
  formula,
  ref_group = NULL,
  qtile_groups = 3,
  es = "g",
  lines = TRUE,
  points = TRUE,
  shade = TRUE,
  shade_alpha = 0.4,
  rects = TRUE,
  rect_fill = "gray20",
  rect_alpha = 0.35,
  refline = TRUE,
  refline_col = "gray40",
  refline_lty = "solid",
  refline_lwd = 1.1
)
}
\arguments{
\item{data}{The data frame to be plotted}

\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups. Additional variables 
can be included with \code{+} to produce separate plots by the secondary or
tertiary variable of interest (e.g., \code{out ~ group + characteristic1 + 
characteristic2}). No more than two additional characteristics can be 
supplied at this time.}

\item{ref_group}{Optional character vector (of length 1) naming the
reference group. Defaults to the group with the highest mean score.}

\item{qtile_groups}{The number of quantile bins to split the data by and 
calculate effect sizes. Defaults to 3 bins (lower, middle, upper).}

\item{es}{The effect size to plot. Defaults to \code{"g"}, in which case 
Hedge's g is plotted, which is better for small samples. At present, the 
only other option is \code{"d"} for Cohen's D.}

\item{lines}{Logical. Should the PP Lines be plotted? Defaults to 
\code{TRUE}.}

\item{points}{Logical. Should points be plotted for each \code{qtiles} be 
plotted? Defaults to \code{TRUE}.}

\item{shade}{Logical. Should the standard errors around the effect size point
estimates be displayed? Defaults to \code{TRUE}, with the uncertainty 
displayed with shading.}

\item{shade_alpha}{Transparency level of the standard error shading.
Defaults to 0.40.}

\item{rects}{Logical. Should semi-transparent rectangles be plotted in the 
background to show the binning? Defaults to \code{TRUE}.}

\item{rect_fill}{Color fill of rectangles to be plotted in the background, if
\code{rects == TRUE}. Defaults to "gray20".}

\item{rect_alpha}{Transparency level of the rectangles in the background when
\code{rects == TRUE}. Defaults to 0.35.}

\item{refline}{Logical. Defaults to \code{TRUE}. Should a diagonal
reference line, representing the point of equal probabilities, be plotted?}

\item{refline_col}{The color of the reference line. Defaults to 
\code{"gray40"}}

\item{refline_lty}{Line type of the reference line. Defaults to
\code{"solid"}.}

\item{refline_lwd}{Line width of the reference line. Defaults to \code{1.1}.}
}
\description{
Plots the effect size between focal and reference groups by matched (binned) 
quantiles (i.e., the results from \link{binned_es}), with the matched
quantiles plotted along the x-axis and the effect size plotted along the 
y-axis. The intent is to examine how (if) the magnitude of the effect size
varies at different points of the distributions. The mean differences within
each quantile bin are divided by the overall pooled standard deviation for 
the two groups being compared.
}
\examples{
# Binned Effect Size Plot: Defaults to Hedges' G
binned_plot(star, math ~ condition)
 
# Same plot, separated by sex
binned_plot(star, math ~ condition + sex)

# Same plot by sex and race
\dontrun{
  pp_plot(star, math ~ condition + sex + race)
}
## Evaluate with simulated data: Plot is most interesting when variance
# in the distributions being compared differ.

library(tidyr)
library(ggplot2)

# simulate data with different variances
set.seed(100)
common_vars <- data.frame(low  = rnorm(1000, 10, 1),
                        high = rnorm(1000, 12, 1),
                        vars = "common")
diff_vars <- data.frame(low  = rnorm(1000, 10, 1),
                      high = rnorm(1000, 12, 2),
                      vars = "diff")
d <- rbind(common_vars, diff_vars)

# Plot distributions 
d <- d \%>\% 
gather(group, value, -vars) 

ggplot(d, aes(value, color = group)) +
 geom_density() +
 facet_wrap(~vars)

# Note that the difference between the distributions depends on where you're 
# evaluating from on the x-axis. The binned plot helps us visualize this. 
# The below shows the binned plots when there is a common versus different
# variance

binned_plot(d, value ~ group + vars)   
}
