% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFCs.R
\name{RFCs}
\alias{RFCs}
\title{Relative Frequency of Citation (RFC)}
\source{
Tardio, J., and M. Pardo-de-Santayana, 2008. Cultural Importance Indices: A Comparative Analysis Based on the Useful Wild Plants of Southern Cantabria (Northern Spain) 1. Economic Botany, 62(1), 24-39. <https://doi.org/10.1007/s12231-007-9004-5>
}
\usage{
RFCs(data)
}
\arguments{
\item{data}{is an ethnobotany data set with column 1 'informant' and 2 'sp_name' as row identifiers of informants and of species names respectively.
The rest of the columns are the identified ethnobotany use categories. The data should be populated with counts of uses per person (should be 0 or 1 values).}
}
\description{
Allows users to calculate the relative frequency of citation (RFC) per species published by Pardo-de-Santayana (2003).
}
\examples{

#Use built-in ethnobotany data example
RFCs(ethnobotanydata)

#Generate random dataset of three informants uses for four species
eb_data <- data.frame(replicate(10,sample(0:1,20,rep=TRUE)))
names(eb_data) <- gsub(x = names(eb_data), pattern = "X", replacement = "Use_")  
eb_data$informant<-sample(c('User_1', 'User_2', 'User_3'), 20, replace=TRUE)
eb_data$sp_name<-sample(c('sp_1', 'sp_2', 'sp_3', 'sp_4'), 20, replace=TRUE)
RFCs(eb_data)

}
\keyword{ethnobotany,}
\keyword{number}
\keyword{of}
\keyword{quantitative}
\keyword{uses}
