% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.euler.R
\name{print.euler}
\alias{print.euler}
\title{Print Euler diagram fits}
\usage{
\method{print}{euler}(x, round = 3, vsep = strrep("-", 0.75 *
  getOption("width")), ...)
}
\arguments{
\item{x}{\code{'euler'} object from \code{\link[=euler]{euler()}}}

\item{round}{number of decimal places to round to}

\item{vsep}{character string to paste in between \code{euler} objects
when \code{x} is a nested \code{euler} object}

\item{...}{arguments passed to \code{\link[base:print.data.frame]{base::print.data.frame()}}}
}
\value{
Summary statistics of the fitted Euler diagram is printed to
screen or a plot is generated.
}
\description{
This function is responsible for printing fits from \code{\link[=euler]{euler()}} and provides
a summary of the fit. Prints a data frame of the original set relationships
and the fitted values as well as \code{diagError} and \code{stress} statistics.
}
\seealso{
\code{\link[=euler]{euler()}}, \code{\link[base:print.data.frame]{base::print.data.frame()}}
}
