% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_plot.R
\name{error_plot}
\alias{error_plot}
\title{Error plot for \code{euler} objects}
\usage{
error_plot(
  x,
  type = c("regionError", "residuals"),
  quantities = TRUE,
  pal = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{euler}, typically the result of
a call to \code{\link[=euler]{euler()}}.}

\item{type}{error metric. \code{'regionError'} is the difference in
\emph{percentage points} from the input}

\item{quantities}{whether to draw the error metric on the plot}

\item{pal}{color palette for the fills in the legend}

\item{...}{arguments passed down to \code{\link[=plot.euler]{plot.euler()}}. Currently,
providing \code{fills}, \code{legend}, or \code{strips} are not allowed and
will return a warning.}
}
\value{
Returns an object of class \code{eulergram}, which will be
plotted on the device in the same manner as objects from
\code{\link[=plot.euler]{plot.euler()}}. See \code{\link[=plot.eulergram]{plot.eulergram()}} for details.
}
\description{
This is a diagnostic tool for evaluating the fit from a call
to \code{\link[=euler]{euler()}} visually. A color key is provided by default, which
represents the chosen error metric so that one can easily detect
which areas in the diagram to be skeptical about.
}
\details{
Notice that this function is purely provided for diagnostic reasons
and does not come with the same kind of customization that
\code{\link[=plot.euler]{plot.euler()}} provides: the color legend can only be customized
in regards to its color palette and another key (instead of labels)
is completely turned off.
}
\examples{
error_plot(euler(organisms), quantities = FALSE)
}
\seealso{
\code{\link[=plot.euler]{plot.euler()}}, \code{\link[=euler]{euler()}},
\code{\link[=plot.eulergram]{plot.eulergram()}}
}
