% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc_grid_to_dt_raw.R
\name{nc_grid_to_dt_raw}
\alias{nc_grid_to_dt_raw}
\title{Convert a netcdf array to long format as data.table (raw version)}
\usage{
nc_grid_to_dt_raw(
  filename,
  variable,
  var_t,
  var_x,
  var_y,
  has_time = TRUE,
  icell_raster_pkg = TRUE
)
}
\arguments{
\item{filename}{Complete path to .nc file.}

\item{variable}{Character, name of the variable to extract (required).}

\item{var_t}{Character, name of the time variable. (recommended if
has_time=TRUE)}

\item{var_x}{(optional) Character, name of the x coordinate variable (not
dimension!). If both var_x and var_y are supplied, results will have xy
columns, too.}

\item{var_y}{(optional) Character, name of the y coordinate variable (not
dimension!). If both var_x and var_y are supplied, results will have xy
columns, too.}

\item{has_time}{Boolean, if \code{TRUE} (default), will read time information
from file. Use \code{FALSE}, if file has no time dimension/variable.}

\item{icell_raster_pkg}{Boolean, if \code{TRUE}, cell indices will be ordered
as if you were extracting the data with the raster package. See also
\code{\link{nc_grid_to_dt}}}
}
\value{
A \code{\link[data.table]{data.table}} with columns icell (cell
  index), time (if has_time=T), value. Only if var_x and var_y supplied also
  x and y. Column names except icell are variable names as in the netcdf
  file.
}
\description{
Extracts a variable from netcdf, similar to \code{\link{nc_grid_to_dt}}, but
in a raw version. Requires more manual info, does not convert time units
(like 'days since x'), and requires xy variables not dimensions (like a
curvilinear grid).
}
\details{
Names of netcdf variables can be inquired in a terminal with "ncdump -h", or
in R for example using \code{ncdf4::nc_open(filename)}.

Example use cases: netcdf file has issues with dimensions (no dimvar), time
variable is in non-standard format.
}
\examples{
# example data
fn3 <- system.file("extdata", "test3.nc", package = "eurocordexr")
dat <- nc_grid_to_dt_raw(fn3, "tasmax", "Times")
str(dat)
}
\seealso{
\code{\link{nc_grid_to_dt}}
}
