% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_hits_trend.R
\name{epmc_hits_trend}
\alias{epmc_hits_trend}
\title{Get the yearly number of hits for a query and the total
yearly number of hits for a given period}
\usage{
epmc_hits_trend(query, synonym = TRUE, data_src = "med",
  period = 1975:2016)
}
\arguments{
\item{query}{query in the Europe PMC syntax}

\item{synonym}{logical, synonym search. If TRUE, synonym terms from MeSH
terminology and the UniProt synonym list are queried, too. Disabled by
default.}

\item{data_src}{character, data source, by default Pubmed/MedLine index  (\code{med})
will be searched.
The following three letter codes represent the sources, which are currently
supported
\describe{
  \item{agr}{Agricola is a bibliographic database of citations to the
  agricultural literature created by the US National Agricultural Library
  and its co-operators.}
  \item{cba}{Chinese Biological Abstracts}
  \item{ctx}{CiteXplore}
  \item{eth}{EthOs Theses, i.e. PhD theses (British Library)}
  \item{hir}{NHS Evidence}
  \item{med}{PubMed/Medline NLM}
  \item{nbk}{Europe PMC Book metadata}
  \item{pat}{Biological Patents}
  \item{pmc}{PubMed Central}
  }}

\item{period}{a vector of years (numeric) over which to perform the search}
}
\value{
a data.frame (dplyr tbl_df) with year, total number of hits
 (all_hits) and number of hits for the query (query_hits)
}
\description{
Get the yearly number of hits for a query and the total
yearly number of hits for a given period
}
\details{
A similar function was used in
 \url{http://www.masalmon.eu/2017/05/14/evergreenreviewgraph/} where
 it was advised to not plot no. of hits over time for a query,
 but to normalize it by the total no. of hits.
}
\examples{
\dontrun{
# aspirin as query
epmc_hits_trend('aspirin', period = 2006:2016, synonym = FALSE)
# link to cran packages in reference lists
epmc_hits_trend('REF:"cran.r-project.org*"', period = 2006:2016, synonym = FALSE)
# more complex with publication type review
epmc_hits_trend('(REF:"cran.r-project.org*") AND (PUB_TYPE:"Review" OR PUB_TYPE:"review-article")',
  period = 2006:2016, synonym = FALSE)
}
}
