% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_country_code.R
\name{harmonize_country_code}
\alias{harmonize_country_code}
\title{Harmonize Country Code}
\usage{
harmonize_country_code(x)
}
\arguments{
\item{x}{A character or a factor vector of eurostat countycodes.}
}
\value{
a vector.
}
\description{
The European Commission and the Eurostat generally uses ISO
   3166-1 alpha-2 codes with two exceptions: EL (not GR) is used to
   represent Greece, and UK (not GB) is used to represent the
   United Kingdom. This function turns country codes into to ISO
   3166-1 alpha-2.
}
\examples{
 \dontrun{
   lp <- get_eurostat("nama_aux_lp")
   lp$geo <- harmonize_country_code(lp$geo)
 }
}
\author{
Janne Huovari \email{janne.huovari@ptt.fi}
}
