% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_eurostat.R
\name{tidy_eurostat}
\alias{tidy_eurostat}
\title{Transform Data into Row-Column-Value Format}
\usage{
tidy_eurostat(
  dat,
  time_format = "date",
  select_time = NULL,
  stringsAsFactors = FALSE,
  keepFlags = FALSE
)
}
\arguments{
\item{dat}{a data_frame from \code{\link[=get_eurostat_raw]{get_eurostat_raw()}}.}

\item{time_format}{a string giving a type of the conversion of the
time column from the eurostat format.
A "date" (default) converts to a \code{\link[=Date]{Date()}}
with a first date of the period. A "date_last"
converts to a \code{\link[=Date]{Date()}} with
a last date of the period. A "num" converts to a numeric and "raw"
does not do conversion. See \code{\link[=eurotime2date]{eurotime2date()}} and
\code{\link[=eurotime2num]{eurotime2num()}}.}

\item{select_time}{a character symbol for a time frequency or NULL
(default).}

\item{stringsAsFactors}{if \code{TRUE} (the default) variables are
converted to factors in original Eurostat order. If \code{FALSE}
they are returned as strings.}

\item{keepFlags}{a logical whether the flags (e.g. "confidential",
"provisional") should be kept in a separate column or if they
can be removed. Default is \code{FALSE}}
}
\value{
tibble in the molten format with the last column 'values'.
}
\description{
Transform raw Eurostat data table into the row-column-value
format (RCV).
}
\references{
See citation("eurostat").
}
\seealso{
\code{\link[=get_eurostat]{get_eurostat()}}
}
\author{
Przemyslaw Biecek, Leo Lahti and Janne Huovari
}
\keyword{database}
\keyword{internal}
\keyword{utilities}
