% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gevrRl.R
\name{gevrRl}
\alias{gevrRl}
\title{GEVr Return Level Estimate and Confidence Interval}
\usage{
gevrRl(z, period, conf = 0.95, method = c("delta", "profile"),
  opt = c("Nelder-Mead", "SANN", "BFGS", "CG", "L-BFGS-B", "Brent"))
}
\arguments{
\item{z}{A class object returned from gevrFit.}

\item{period}{The number of periods to use for the return level.}

\item{conf}{Confidence level. Defaults to 95 percent.}

\item{method}{The method to compute the confidence interval - either delta method (default) or profile likelihood.}

\item{opt}{Optimization method to maximize the profile likelihood if that is selected. The default method is Nelder-Mead.}
}
\value{
\item{Estimate}{Estimated m-period return level.}
\item{CI}{Confidence interval for the m-period return level.}
\item{Period}{The period length used.}
\item{ConfLevel}{The confidence level used.}
}
\description{
Computes m-period return level estimate and interval, using either the delta method or profile likelihood.
}
\details{
It is generally accepted that profile likelihood confidence intervals provide greater accuracy than the delta
method, in particular for large return level periods. Also, by their nature, delta method confidence intervals must be symmetric
which may be undesirable for return level estimation.
}
\examples{
x <- rgevr(100, 2, loc = 0.5, scale = 1, shape = 0.3)
z <- gevrFit(x)
## Compute 250-period return level.
gevrRl(z, 250, method = "delta")
}
\references{
http://www.mas.ncl.ac.uk/~nlf8/teaching/mas8391/background/chapter2.pdf

Coles, S. (2001). An introduction to statistical modeling of extreme values (Vol. 208). London: Springer.
}

