% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAPE.R
\name{PAPE}
\alias{PAPE}
\title{Estimation of the Population Average Prescription Effect in Randomized Experiments}
\usage{
PAPE(T, That, Y, plim = NA, centered = TRUE)
}
\arguments{
\item{T}{A vector of the unit-level binary treatment receipt variable for each sample.}

\item{That}{A vector of the unit-level binary treatment that would have been assigned by the
individualized treatment rule. If \code{plim} is specified, please ensure
that the percentage of treatment units of That is lower than the budget constraint.}

\item{Y}{A vector of the outcome variable of interest for each sample.}

\item{plim}{The maximum percentage of population that can be treated under the
budget constraint. Should be a decimal between 0 and 1. Default is NA which assumes
no budget constraint.}

\item{centered}{If \code{TRUE}, the outcome variables would be centered before processing. This minimizes
the variance of the estimator. Default is \code{TRUE}.}
}
\value{
A list that contains the following items: \item{pape}{The estimated
Population Average Prescription Effect.} \item{sd}{The estimated standard deviation
of PAPE.}
}
\description{
This function estimates the Population Average Prescription Effect with and without a budget
constraint. The details of the methods for this design are given in Imai and Li (2019).
}
\examples{
T = c(1,0,1,0,1,0,1,0)
That = c(0,1,1,0,0,1,1,0)
Y = c(4,5,0,2,4,1,-4,3)
papelist <- PAPE(T,That,Y)
papelist$pape
papelist$sd
}
\references{
Imai and Li (2019). \dQuote{Experimental Evaluation of Individualized Treatment Rules},
}
\author{
Michael Lingzhi Li, Operations Research Center, Massachusetts Institute of Technology
\email{mlli@mit.edu}, \url{http://mlli.mit.edu};
}
\keyword{evaluation}
