% Generated by roxygen2 (4.0.1): do not edit by hand
\name{fitmweibullgpd}
\alias{fitmweibullgpd}
\alias{litmweibullgpd}
\alias{nleuitmweibullgpd}
\alias{nlitmweibullgpd}
\alias{nluitmweibullgpd}
\alias{profleuitmweibullgpd}
\alias{profluitmweibullgpd}
\title{MLE Fitting of Weibull Bulk and GPD Tail Interval Transition Mixture Model}
\usage{
fitmweibullgpd(x, eseq = NULL, useq = NULL, fixedeu = FALSE,
  pvector = NULL, std.err = TRUE, method = "BFGS", control = list(maxit
  = 10000), finitelik = TRUE, ...)

litmweibullgpd(x, wshape = 1, wscale = 1, epsilon = sqrt(wscale^2 *
  gamma(1 + 2/wshape) - (wscale * gamma(1 + 1/wshape))^2), u = qweibull(0.9,
  wshape, wscale), sigmau = sqrt(wscale^2 * gamma(1 + 2/wshape) - (wscale *
  gamma(1 + 1/wshape))^2), xi = 0, log = TRUE)

nlitmweibullgpd(pvector, x, finitelik = FALSE)

profleuitmweibullgpd(eu, pvector, x, method = "BFGS", control = list(maxit =
  10000), finitelik = FALSE, ...)

nleuitmweibullgpd(pvector, epsilon, u, x, finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{eseq}{vector of epsilons (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{useq}{vector of thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedeu}{logical, should threshold and epsilon be fixed
(at either scalar value in \code{useq} and \code{eseq},
or estimated from maximum of profile likelihood evaluated at
grid of thresholds and epsilons in \code{useq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{epsilon}{interval half-width}

\item{u}{scalar threshold value}

\item{sigmau}{scalar scale parameter (positive)}

\item{xi}{scalar shape parameter}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}

\item{eu}{vector of epsilon and threshold pair considered in profile likelihood}

\item{wshape}{scalar Weibull shape (positive)}

\item{wscale}{scalar Weibull scale (positive)}
}
\value{
Log-likelihood is given by \code{\link[evmix:fitmweibullgpd]{litmweibullgpd}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:fitmweibullgpd]{nlitmweibullgpd}}
  and \code{\link[evmix:fitmweibullgpd]{nluitmweibullgpd}}. Profile likelihood for
  threshold and interval half-width given by \code{\link[evmix:fitmweibullgpd]{profluitmweibullgpd}}.
  Fitting function \code{\link[evmix:fitmweibullgpd]{fitmweibullgpd}} returns a simple list
  with the following elements

\tabular{ll}{
 \code{call}:    \tab \code{optim} call\cr
 \code{x}:       \tab data vector \code{x}\cr
 \code{init}:    \tab \code{pvector}\cr
 \code{fixedeu}: \tab fixed epsilon and threshold, logical\cr
 \code{useq}:    \tab threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{eseq}:    \tab epsilon vector for profile likelihood or scalar for fixed epsilon\cr
 \code{optim}:   \tab complete \code{optim} output\cr
 \code{mle}:     \tab vector of MLE of parameters\cr
 \code{cov}:     \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:      \tab vector of standard errors of MLE of parameters\cr
 \code{nllh}:    \tab minimum negative log-likelihood\cr
 \code{n}:       \tab total sample size\cr
 \code{wshape}:  \tab MLE of Weibull shape\cr
 \code{wscale}:  \tab MLE of Weibull scale\cr
 \code{epsilon}: \tab MLE of transition half-width\cr
 \code{u}:       \tab threshold (fixed or MLE)\cr
 \code{sigmau}:  \tab MLE of GPD scale\cr
 \code{xi}:      \tab MLE of GPD shape\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme valeu
mixture model with the Weibull bulk and GPD tail interval transition mixture model.
With options for profile likelihood estimation for threshold and interval half-width,
which can both be fixed.
}
\details{
The extreme value mixture model with the Weibull bulk and GPD tail with interval
transition is fitted to the entire dataset using maximum likelihood estimation.
The estimated parameters, variance-covariance matrix and their standard errors are automatically
output.

See \code{\link[evmix:itmweibullgpd]{ditmweibullgpd}} for explanation of Weibull-GPD interval
transition model, including mixing functions.

See also help for \code{\link[evmix:fnormgpd]{fnormgpd}} for mixture model fitting details.
Only the different features are outlined below for brevity.

The full parameter vector is
(\code{wshape}, \code{wscale}, \code{epsilon}, \code{u}, \code{sigmau}, \code{xi})
if threshold and interval half-width are both estimated and
(\code{wshape}, \code{wscale}, \code{sigmau}, \code{xi})
for profile likelihood or fixed threshold and epsilon approach.

If the profile likelihood approach is used, then it is applied to both the threshold and
epsilon parameters together. A grid search over all combinations of epsilons and thresholds
are considered. The combinations which lead to less than 5 on either side of the interval are
not considered.

A fixed threshold and epsilon approach is acheived by setting a single scalar value to each in
\code{useq} and \code{eseq} respectively.

Negative data are ignored.
}
\note{
When \code{pvector=NULL} then the initial values are:
\itemize{
 \item MLE of Weibull parameters assuming entire population is Weibull; and
 \item epsilon is MLE of Weibull standard deviation;
 \item threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD parameters above threshold.
}
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}.
}
\examples{
\dontrun{
x = rweibull(1000, shape = 1, scale = 2)
xx = seq(-0.2, 10, 0.01)
y = dweibull(xx, shape = 1, scale = 2)

# MLE for complete parameter set
fit = fitmweibullgpd(x)
hist(x, breaks = seq(0, 20, 0.1), freq = FALSE, xlim = c(-0.2, 10))
lines(xx, y)
with(fit, lines(xx, ditmweibullgpd(xx, wshape, wscale, epsilon, u, sigmau, xi), col="red"))
abline(v = fit$u + fit$epsilon * seq(-1, 1), col = "red")

# Profile likelihood for threshold which is then fixed
fitu = fitmweibullgpd(x, eseq = seq(0, 2, 0.1), useq = seq(0.5, 4, 0.1), fixedeu = T)
with(fitu, lines(xx, ditmweibullgpd(xx, wshape, wscale, epsilon, u, sigmau, xi), col="blue"))
abline(v = fitu$u + fitu$epsilon * seq(-1, 1), col = "blue")
legend("topright", c("True Density", "Weibull-GPD ITM", "Profile likelihood"),
  col=c("black", "red", "blue"), lty = 1)
}
}
\author{
Alfadino Akbar and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Weibull_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Holden, L. and Haug, O. (2013). A mixture model for unsupervised tail
estimation. arxiv:0902.4137
}
\seealso{
\code{\link[stats:Weibull]{dweibull}},
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}
}

