% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSProjection.R
\name{RSProjection}
\alias{RSProjection}
\title{Random Skewers projection}
\usage{
RSProjection(cov.matrix.array, p = 0.95, num.vectors = 1000)
}
\arguments{
\item{cov.matrix.array}{Array with dimentions traits x traits x populations x MCMCsamples}

\item{p}{significance treashhold for comparison of variation in each random direction}

\item{num.vectors}{number of random vectors}
}
\value{
projection of all matrices in all random vectors

set of random vectors and confidence intervals for the projections

eigen decomposition of the random vectors in directions with significant differences of variations
#@export
}
\description{
Not tested!
Uses MCMC Bayeisian posterior samples of a set of covariance matrices to identify 
directions of the morphospace in which these matrices differ in their amount of genetic variance.
}
\examples{
#random set of covariance matrices 
cov.matrices = aperm(aaply(1:15, 1, function(x) 
                     laply(RandomMatrix(10, 100, 
                           variance = runif(10, 1, 10)), 
                           identity)), 
                     c(3, 4, 1, 2))
#rs_proj = evolqg:::RSProjection(cov.matrices, p = 0.8)  
#plot(rs.proj, cov.matrices)
}
\references{
Aguirre, J. D., E. Hine, K. McGuigan, and M. W. Blows. "Comparing G: multivariate analysis of genetic variation in multiple populations." Heredity 112, no. 1 (2014): 21-29.
}

