% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charging_infrastructure.R
\name{add_charging_infrastructure}
\alias{add_charging_infrastructure}
\title{Assign charging station to charging sessions data set}
\usage{
add_charging_infrastructure(
  sessions,
  resolution = 15,
  min_stations = 0,
  names_prefix = NULL,
  connections_th = 10
)
}
\arguments{
\item{sessions}{tibble, sessions data set in standard format marked by \code{{evprof}} package
(see \href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{this article})}

\item{resolution}{integer, time resolution in minutes}

\item{min_stations}{integer, minimum number of charging stations to consider}

\item{names_prefix}{character, prefix of the charging station names (optional)}

\item{connections_th}{integer, minimum percentage of time intervals than a
certain number of vehicles have been connected.
This is used to avoid sizing a charging infrastructure to host for example
100 vehicles when only 5\% of time there are more than 80 vehicles connected.
Then, setting \code{connections_th = 5} will ensure that we don't over-size
the charging infrastructure. It is recommended to find this value through
multiple iterations.}
}
\value{
tibble
}
\description{
Variable \code{ChargingStation} and \code{Socket}will be assigned to the \code{sessions}
tibble with a name pattern being: \code{names_prefix} + "CHS" + number
}
\examples{
# Assign a `ChargingStation` to every session according to the occupancy
sessions_infrastructure <- add_charging_infrastructure(
  sessions = head(evsim::california_ev_sessions, 50),
  resolution = 60, connections_th = 0
)
print(unique(sessions_infrastructure$ChargingStation))


}
