% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{estimate_sessions}
\alias{estimate_sessions}
\title{Estimate sessions parameters of a specific profile}
\usage{
estimate_sessions(
  profile_name,
  n_sessions,
  power,
  connection_models,
  energy_models,
  connection_log,
  energy_log,
  charging_powers
)
}
\arguments{
\item{profile_name}{character, profile name}

\item{n_sessions}{integer, total number of sessions per day}

\item{power}{numeric, charging power of the session}

\item{connection_models}{tibble, bivariate GMM of the profile}

\item{energy_models}{tibble, univariate GMM of the profile}

\item{connection_log}{logical, true if connection models have logarithmic transformations}

\item{energy_log}{logical, true if energy models have logarithmic transformations}

\item{charging_powers}{tibble with variables \code{power} and \code{ratio}
The powers must be in kW and the ratios between 0 and 1.}
}
\value{
tibble
}
\description{
Estimate sessions parameters of a specific profile
}
\keyword{internal}
