% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{ESTEP.rd}
\alias{ESTEP.rd}
\title{Calculate E-P-values based on LR statistic.}
\usage{
ESTEP.rd(n0, n1, psi = 0, J = NULL, dec.places = 10, prin = FALSE)
}
\arguments{
\item{n0}{control sample size}

\item{n1}{treatment sample size}

\item{psi}{null value of risk difference p1-p0}

\item{J}{index of single data set if desired}

\item{dec.places}{number of decimal places of output t-values and p-values.}

\item{prin}{outputs expected time and progress of calculation}
}
\value{
A list with elements \item{y0,y1}{data sets (scalar or vector)}
\item{oldP}{approximate p-value(s) before E-step} \item{T, P}{quasi-exact
P-value(s) and equivalent T-value(s)} \item{pmle}{profile ML estimates of
baseline probability} \item{index}{consistent code to select a single
outcome} \item{psi}{scalar null value of p1-p0}
}
\description{
Calculates all possible values of the E-P-value for testing p1-p0 greater
than a provided null value psi.
}
\details{
This function can take a long time for larger sample sizes. The computation
time is of order (n0*n1)^2.
}
\references{
C.J. Lloyd & R. Ripamonti (2021) A comprehensive open-source
library for exact required sample size in binary clinical trials.
Contemporary Clinical Trials 107. \doi{10.1016/j.cct.2021.106491}
}
\author{
Chris J. Lloyd
}
\keyword{internal}
