% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch02TestItemAnalysis.R
\name{CCRR}
\alias{CCRR}
\title{Conditional Correct Response Rate}
\usage{
CCRR(U, na = NULL, Z = NULL, w = NULL, ...)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{...}{Internal parameters for maintaining compatibility with the binary data
processing system. Not intended for direct use.}
}
\value{
A matrix of conditional correct response rates with exametrika class.
Each element (i,j) represents the probability of correctly answering item j
given that item i was answered correctly.
}
\description{
The conditional correct response rate (CCRR) represents the ratio of the students
who passed Item C (consequent item) to those who passed Item A (antecedent item).
This function is applicable only to binary response data.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# example code
# Calculate CCRR using sample dataset J5S10
CCRR(J5S10)
}
