% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractions.R
\name{fractions}
\alias{fractions}
\alias{approx_rational}
\title{Fractions}
\usage{
fractions(x, cycles = 10, max.denominator = 2000, ...)

approx_rational(x, cycles = 10, max.denominator = 2000, ...)
}
\arguments{
\item{x}{any object of the numeric mode (missing values are allowed)}

\item{cycles}{the maximum number of steps to be used in the continued fraction approximation process}

\item{max.denominator}{an early termination criterion. If any partial denominator exceeds \code{max.denominator}, the continued fraction stops at that point}

\item{...}{further arguments}
}
\value{
An object of the class \code{fractions}. A structure with a \code{.Data} component, the same as the numeric \code{x} input,
but with the rational approximations held as the character vector attribute \code{fracs}. Arithmetic operations on \code{fractions} objects are possible.
}
\description{
Finds rational approximations to the components of a real numeric object, using a standard continued fraction method.
Calls \code{\link[MASS:fractions]{MASS::fractions()}} (Please refer to that for further details).
}
\examples{
X <- matrix(runif(25), 5, 5)
fractions(X) #;)
fractions(solve(X, X/5))
fractions(solve(X, X/5)) + 1
}
