% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.R
\name{check_preview}
\alias{check_preview}
\title{Check for survey previews}
\usage{
check_preview(
  x,
  id_col = "ResponseId",
  preview_col = "Status",
  keep = FALSE,
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{preview_col}{Column name for survey preview.}

\item{keep}{Logical indicating whether to keep or remove exclusion column.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
The output is a data frame of the rows
that are survey previews.
For a function that marks these rows, use \code{\link[=mark_preview]{mark_preview()}}.
For a function that excludes these rows, use \code{\link[=exclude_preview]{exclude_preview()}}.
}
\description{
The \code{check_preview()} function subsets rows of data, retaining rows
that are survey previews.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
The preview column in Qualtrics can be a numeric or character vector
depending on whether it is exported as choice text or numeric values.
This function works for both.

The function outputs to console a message about the number of rows
that are survey previews.
}
\examples{
# Check for survey previews
data(qualtrics_text)
check_preview(qualtrics_text)

# Works for Qualtrics data exported as numeric values, too
qualtrics_numeric \%>\%
  check_preview()

# Do not print rows to console
qualtrics_text \%>\%
  check_preview(print = FALSE)

# Do not print message to console
qualtrics_text \%>\%
  check_preview(quiet = TRUE)
}
\seealso{
Other preview functions: 
\code{\link{exclude_preview}()},
\code{\link{mark_preview}()}

Other check functions: 
\code{\link{check_duplicates}()},
\code{\link{check_duration}()},
\code{\link{check_ip}()},
\code{\link{check_location}()},
\code{\link{check_progress}()},
\code{\link{check_resolution}()}
}
\concept{check functions}
\concept{preview functions}
