% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_methods.R
\name{summary.spm}
\alias{summary.spm}
\title{Summary method for an \code{"spm"} object}
\usage{
\method{summary}{spm}(object, digits = max(3, getOption("digits") - 3L),
  ...)
}
\arguments{
\item{object}{an object of class "spm", a result of a call to
\code{\link{spm}}.}

\item{digits}{An integer. Used for number formatting with
\code{\link[base:Round]{signif}}.}

\item{...}{Additional arguments.  None are used in this function.}
}
\value{
Returns a list containing the list element \code{object$call}
  and a numeric matrix \code{summary} giving, for all three variants of the
  semiparametric estimator and both sliding and disjoint blocks,
  the (bias-adjusted) Estimate of the extremal index \eqn{\theta},
  the estimated standard error (Std. Error),
  and the bias adjustment (Bias adj.) applied to obtain the estimate, i.e.
  the value subtracted from the raw estimate.  If any of the
  (bias-adjusted) estimates are greater than 1 then a column
  containing the unconstrained estimates (Uncon. estimate) is added.
}
\description{
\code{summary} method for class \code{"spm"}
}
\section{Examples}{

See the examples in \code{\link{spm}}.
}

\seealso{
\code{\link{spm}} for estimation of the extremal index
  \eqn{\theta} using a semiparametric maxima method.

\code{\link{confint.spm}} for estimation of confidence intervals
  for \eqn{\theta}.
}
