% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_num.R
\name{evaluate_mad}
\alias{evaluate_mad}
\title{Evaluate median absolute deviation}
\usage{
evaluate_mad(i, pheno)
}
\arguments{
\item{i}{List of indices}

\item{pheno}{Data.frame with information about the samples}
}
\value{
A vector with the mean difference between the median absolute deviation
of each group and the original mad.
}
\description{
Looks for the median absolute deviation values in each subgroup.
}
\examples{
data(survey, package = "MASS")
index <- design(survey[, c("Sex", "Smoke", "Age")], size_subset = 50,
                iterations = 10)
# Note that categorical columns will be omitted:
evaluate_mad(index, survey[, c("Sex", "Smoke", "Age")])
}
\seealso{
Other functions to evaluate samples: 
\code{\link{evaluate_entropy}()},
\code{\link{evaluate_independence}()},
\code{\link{evaluate_index}()},
\code{\link{evaluate_mean}()},
\code{\link{evaluate_na}()},
\code{\link{evaluate_orig}()},
\code{\link{evaluate_sd}()}

Other functions to evaluate numbers: 
\code{\link{evaluate_mean}()},
\code{\link{evaluate_na}()},
\code{\link{evaluate_sd}()}
}
\concept{functions to evaluate numbers}
\concept{functions to evaluate samples}
