% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAPE.R
\name{PAPE}
\alias{PAPE}
\title{Estimation of the Population Average Prescription Effect in Completely Randomized Experiments}
\usage{
PAPE(T, That, Y, plim = NA)
}
\arguments{
\item{T}{The unit-level binary treatment receipt variable.}

\item{That}{The unit-level binary treatment that would have been assigned by the 
individualized treatment rule.}

\item{Y}{The outcome variable of interest.}

\item{plim}{The maximum percentage of population that can be treated under the
budget constraint. Should be a decimal between 0 and 1. Default is NA which assumes
no budget constraint.}
}
\value{
A list that contains the following items: \item{pape}{The estimated
Population Average Prescription Effect.} \item{sd}{The estimated standard deviation
of PAPE.}
}
\description{
This function estimates the Population Average Prescription Effect with and without a budget
constraint. The details of the methods for this design are given in Imai and Li (2019).
}
\references{
Imai and Li (2019). \dQuote{Experimental Evaluation of Individualized Treatment Rules},
}
\author{
Michael Lingzhi Li, Operations Research Center, Massachusetts Institute of Technology
\email{mlli@mit.edu}, \url{http://mlli.mit.edu};
}
\keyword{evaluation}
