% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-predict.R
\docType{methods}
\name{calcStats}
\alias{calcStats}
\alias{calcStats,ExprsPredict-method}
\title{Calculate Classifier Performance}
\usage{
calcStats(object, aucSkip = FALSE, plotSkip = FALSE)

\S4method{calcStats}{ExprsPredict}(object, aucSkip = FALSE,
  plotSkip = FALSE)
}
\arguments{
\item{object}{An \code{ExprsPredict} object.}

\item{aucSkip}{A logical scalar. Toggles whether to calculate area under the
receiver operating characteristic curve. See details.}

\item{plotSkip}{A logical scalar. Toggles whether to plot the receiver
operating characteristic curve.}
}
\value{
Returns a \code{data.frame} of performance metrics.
}
\description{
\code{calcStats} calculates classifier performance based on the class predictions
 and actual class labels stored in an \code{ExprsPredict} object.
}
\details{
This function calculates classifier performance based on the predicted
 class labels and the actual class labels in one of two ways. If the argument
 \code{aucSkip = FALSE} AND the \code{ExprsArray} object was an \code{ExprsBinary}
 object with at least one case and one control AND \code{ExprsPredict} contains
 a coherent \code{@probability} slot, \code{calcStats} will calculate classifier
 performance using the area under the receiver operating characteristic (ROC) curve
 via the \code{ROCR} package. Otherwise, \code{calcStats} will calculate classifier
 performance traditionally using a confusion matrix. Note that accuracies calculated
 using \code{ROCR} may differ from accuracies calculated using a confusion
 matrix because the former may adjust the discrimination threshold to optimize
 sensitivity and specificity. The discrimination threshold is automatically chosen
 as the point along the ROC which minimizes the Euclidean distance from (0, 1).
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsPredict}: Method to calculate the performance of a deployed classifier.
}}
\seealso{
\code{\link{exprso-predict}}
}

