% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria_functions.R
\name{criteria}
\alias{criteria}
\alias{eq}
\alias{ne}
\alias{neq}
\alias{lt}
\alias{gt}
\alias{le}
\alias{lte}
\alias{ge}
\alias{gte}
\alias{perl}
\alias{regex}
\alias{fixed}
\alias{thru}
\alias{\%thru\%}
\alias{from}
\alias{to}
\alias{items}
\alias{not_na}
\alias{other}
\alias{as.criterion}
\title{Criteria functions}
\usage{
eq(x)

ne(x)

neq(x)

lt(x)

gt(x)

le(x)

lte(x)

ge(x)

gte(x)

perl(pattern, ignore.case = FALSE, useBytes = FALSE)

regex(pattern, ignore.case = FALSE, useBytes = FALSE)

fixed(pattern, ignore.case = FALSE, useBytes = FALSE)

thru(lower, upper)

lower \%thru\% upper

from(x)

to(x)

items(...)

not_na(x)

other(x)

as.criterion(crit)
}
\arguments{
\item{x}{vector}

\item{pattern}{character string containing a regular expression (or character
string for \code{fixed}) to be matched in the given character vector.
Coerced by as.character to a character string if possible.}

\item{ignore.case}{logical see \link[base]{grepl}}

\item{useBytes}{logical see \link[base]{grepl}}

\item{lower}{vector/single value - lower bound of interval}

\item{upper}{vector/single value - upper bound of interval}

\item{...}{numeric indexes of desired items}

\item{crit}{vector of values/function which returns logical or vector. It will be
converted to function of class criterion.}
}
\value{
function of class 'criterion' which tests its argument against
  condition and return logical value
}
\description{
These functions returns criteria functions which could be used in different 
situation - see \link{keep}, \link{except}, \link{recode}, \link{na_if},
\link{\%i\%}, \link{\%d\%}, \link{count_if}, \link{match_row} etc. For
example, \code{gt(5)} returns function which tests whether its argument
greater than five.
\code{fixed("apple")} return function which tests whether its argument
contains "apple". Logical operations (|, &, !, xor) are defined for these
functions.
List of functions:
\itemize{
\item{\code{gt}}{ greater than}
\item{\code{ge}/\code{gte}}{ greater than or equal}
\item{\code{eq}}{ equal} 
\item{\code{ne}/\code{neq}}{ not equal} 
\item{\code{lt}}{ less than}
\item{\code{le}/\code{lte}}{ less than or equal}
\item{\code{thru}}{ checks whether value is inside interval.
\code{thru(0,1)} is equivalent of \code{x>=0 & x<=1} or \code{ge(0) &
le(1)}}
\item{\code{\%thru\%}}{ infix version of \code{thru}, e. g. \code{0 \%thru\% 1}}
\item{\code{regex}}{ use POSIX 1003.2 extended regular expressions. For details see \link[base]{grepl}}
\item{\code{perl}}{ perl-compatible regular expressions. For details see \link[base]{grepl}}
\item{\code{fixed}}{ pattern is a string to be matched as is. For details see \link[base]{grepl}}
\item{\code{to}}{ returns function which gives TRUE for all elements of
vector before the first occurrence of \code{x} and for  \code{x}.}
\item{\code{from}}{ returns function which gives TRUE for all elements of 
vector after the first occurrence of \code{x} and for \code{x}. \code{from} and
\code{to} are intended for usage with \link{keep} and \link{except}.}
\item{\code{not_na}}{ return TRUE for all non-NA elements of vector.} 
\item{\code{other}}{ return TRUE for all elements of vector. It is intended
for usage with \code{if_val}, \code{keep}, \code{except}}
\item{\code{items}}{ return TRUE for elements of vector with given
sequential number. It is intended for usage with \code{keep}, \code{except}}
}
}
\examples{
# operations on vector
1:6 \%d\% gt(4) # 1:4

1:6 \%d\% (1 | gt(4)) # 2:4

letters \%i\% (fixed("a") | fixed("z")) # a, z

letters \%i\% from("w")  # w, x, y, z

letters \%i\% to("c")  # a, b, c

letters \%i\% (from("b") & to("e"))  # b, d, e

c(1, 2, NA, 3) \%i\% other # c(1, 2, 3)

# examples with count_if
df1 = data.frame(
    a=c("apples", "oranges", "peaches", "apples"),
    b = c(32, 54, 75, 86)
)

count_if(gt(55), df1$b) # greater than 55 = 2

count_if(ne(75), df1$b) # not equal 75 = 3

count_if(ge(32), df1$b) # greater than or equal 32 = 4

count_if(gt(32) & lt(86), df1$b) # greater than 32 and less than 86 = 2

# via different kinds of 'thru'
count_if(thru(35, 80), df1$b) # greater than or equals to 35 and less than or equals to 80 = 2
# infix version
count_if(35 \%thru\% 80, df1$b) # greater than or equals to 35 and less than or equals to 80 = 2

# values that started on 'a'
count_if(regex("^a"), df1) # 2

# count_row_if
count_row_if(regex("^a"), df1) # c(1,0,0,1)

# examples with 'keep' and 'except'

data(iris)
iris \%keep\% to("Petal.Width") # column 'Species' will be removed 
 
# 'Sepal.Length', 'Sepal.Width' will be left 
iris \%except\% from("Petal.Length") 

# except first column
iris \%except\% items(1)

# if_val examples
# From SPSS: RECODE QVAR(1 THRU 5=1)(6 THRU 10=2)(11 THRU HI=3)(ELSE=0).
set.seed(123)
qvar = sample((-5):20, 50, replace = TRUE)
recode(qvar, 1 \%thru\% 5 ~ 1, 6 \%thru\% 10 ~ 2, 11 \%thru\% hi ~ 3, other ~ 0)
# the same result
recode(qvar, 1 \%thru\% 5 ~ 1, 6 \%thru\% 10 ~ 2, ge(11) ~ 3, other ~ 0)


}
\seealso{
\link{recode}, \link{keep}, \link{except}, \link{count_if},
  \link{match_row}, \link{na_if}, \link{\%i\%}, \link{\%d\%}
}
