% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{var_lab}
\alias{var_lab}
\alias{var_lab<-}
\alias{set_var_lab}
\alias{unvr}
\title{Set or get variable label}
\usage{
var_lab(x)

var_lab(x) <- value

set_var_lab(x, value)

unvr(x)
}
\arguments{
\item{x}{Variable. In the most cases it is numeric vector.}

\item{value}{A character scalar - label for the variable x.}
}
\value{
\code{var_lab} return variable label. If label doesn't exist it return
  NULL . \code{var_lab<-} and \code{set_var_lab} return variable (vector x)
  of class "labelled" with attribute "label" which equals submitted value.
}
\description{
These functions set/get/drop variable labels. For 
value labels see \link{val_lab}. For working with entire data.frame see
\link{apply_labels}.
\itemize{
\item{\code{var_lab}}{ returns variable label or NULL if label doesn't 
exist.} 
\item{\code{var_lab<-}}{ set variable label.} 
\item{\code{set_var_lab}}{ returns variable with label.}
\item{\code{unvr}}{ drops variable label.} 
}
}
\details{
Variable label is stored in attribute "label" (\code{attr(x,"label")}). For
  preserving from dropping this attribute during some operations (such as \code{c})
  variable class is set to "labelled". There are special methods of
  subsetting and concatenation for this class. To drop variable label use 
  \code{var_lab(var) <- NULL} or \code{unvr(var)}.
}
\examples{
data(mtcars)
mtcars = modify(mtcars,{
                var_lab(mpg) = "Miles/(US) gallon"
                var_lab(cyl) = "Number of cylinders"
                var_lab(disp) = "Displacement (cu.in.)"
                var_lab(hp) = "Gross horsepower"
                var_lab(drat) = "Rear axle ratio"
                var_lab(wt) = "Weight (lb/1000)"
                var_lab(qsec) = "1/4 mile time"
                var_lab(vs) = "V/S"
                var_lab(am) = "Transmission (0 = automatic, 1 = manual)"
                val_lab(am) = c(automatic = 0, manual=1)
                var_lab(gear) = "Number of forward gears"
                var_lab(carb) = "Number of carburetors"
})

fre(mtcars$am)

calculate(mtcars, 
     cro_mean(list(mpg, disp, hp, qsec), list(total(), am))
     ) 


}
