% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep.R
\name{keep}
\alias{keep}
\alias{.keep}
\alias{except}
\alias{.except}
\title{Keep or drop elements by name/criteria in data.frame/matrix}
\usage{
keep(data, ...)

.keep(...)

except(data, ...)

.except(...)
}
\arguments{
\item{data}{data.frame/matrix/list}

\item{...}{column names of type character/numeric or criteria/logical functions}
}
\value{
object of the same type as \code{data}
}
\description{
\code{keep} selects variables/elements from data.frame by their names or by 
criteria (see \link{criteria}). \code{except} drops variables/elements from 
data.frame by their names or by criteria. Names at the top-level can be
unquoted (non-standard evaluation). For standard evaluation of parameters you
can surround them by round brackets. See examples. Methods for list will apply
\code{keep}/\code{except} to each element of the list separately.
\code{.keep}/\code{.except} are versions which works with
\link{default_dataset}.
}
\examples{
data(iris)
keep(iris, Sepal.Length, Sepal.Width)  
except(iris, Species)

keep(iris, Species, other()) # move 'Species' to the first position
keep(iris, to("Petal.Width")) # keep all columns up to 'Species'

except(iris, perl("^Petal")) # remove columns which names start with 'Petal'

except(iris, 5) # remove fifth column

data(mtcars)
keep(mtcars, from("mpg") & to("qsec")) # keep columns from 'mpg' to 'qsec'
keep(mtcars, mpg \%to\% qsec) # the same result

 # standard and non-standard evaluation
 many_vars = c("am", "vs", "cyl")
 \dontrun{
 keep(mtcars, many_vars) # error - names not found: 'many_vars'  
  }
 keep(mtcars, (many_vars)) # ok
 
# character expansion
dfs = data.frame(
     a = 10 \%r\% 5,
     b_1 = 11 \%r\% 5,
     b_2 = 12 \%r\% 5,
     b_3 = 12 \%r\% 5,
     b_4 = 14 \%r\% 5,
     b_5 = 15 \%r\% 5 
 )
 i = 1:5
 keep(dfs, b_1 \%to\% b_5) 
 keep(dfs, text_expand("b_{i}")) # the same result  
}
