% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtotal.R
\name{net}
\alias{net}
\alias{subtotal}
\alias{tab_net_cells}
\alias{tab_net_cols}
\alias{tab_net_rows}
\alias{tab_subtotal_cells}
\alias{tab_subtotal_cols}
\alias{tab_subtotal_rows}
\title{Add subtotal to a set of categories}
\usage{
net(x, ..., position = c("below", "above", "top", "bottom"),
  prefix = "TOTAL ", new_label = c("all", "range", "first", "last"),
  add = FALSE)

subtotal(x, ..., position = c("below", "above", "top", "bottom"),
  prefix = "TOTAL ", new_label = c("all", "range", "first", "last"),
  add = TRUE)

tab_net_cells(data, ..., position = c("below", "above", "top", "bottom"),
  prefix = "TOTAL ", new_label = c("all", "range", "first", "last"))

tab_net_cols(data, ..., position = c("below", "above", "top", "bottom"),
  prefix = "TOTAL ", new_label = c("all", "range", "first", "last"))

tab_net_rows(data, ..., position = c("below", "above", "top", "bottom"),
  prefix = "TOTAL ", new_label = c("all", "range", "first", "last"))

tab_subtotal_cells(data, ..., position = c("below", "above", "top",
  "bottom"), prefix = "TOTAL ", new_label = c("all", "range", "first",
  "last"))

tab_subtotal_cols(data, ..., position = c("below", "above", "top",
  "bottom"), prefix = "TOTAL ", new_label = c("all", "range", "first",
  "last"))

tab_subtotal_rows(data, ..., position = c("below", "above", "top",
  "bottom"), prefix = "TOTAL ", new_label = c("all", "range", "first",
  "last"))
}
\arguments{
\item{x}{variable, list, data.frame or multiple response set}

\item{...}{list of categories for grouping. It can be numeric vectors (for
example, 1:2), ranges (for example, 4 %thru% hi) or criteria (for example,
greater(5)). If an argument is named then this name will be used as label for
subtotal.}

\item{position}{position of the subtotal or net relative to original
categories. "below" by default. One of the "below", "above", "top",
"bottom". "top" and "bottom" place nets and subtotals above or below all
other categories. For nets "below" and "above" have no difference because
original categories are removed.}

\item{prefix}{character, "TOTAL " by default. It is a prefix to automatically
created labels for nets and subtotals.}

\item{new_label}{how we will combine original values for automatically
generated subtotal labels. Possible values are "all", "range", "first",
"last". "all" collapse all labels, "range" take only first and last label,}

\item{add}{logical. Auxiliary argument. Should we add subtotal to categories or replace categories with a net?}

\item{data}{intermediate table. See \link{tables}.}
}
\value{
multiple response set or list of the multiple response sets
}
\description{
'subtotal' adds subtotal to set of categories, 'net' replaces categories with
their net value. If you provide named arguments then name will be used as
label for subtotal. In other case labels will be automatically generated
taking into account arguments 'new_label' and 'prefix'. Note that if you
provide overlapping categories then net and subtotals will also be
overlapping. 'subtotal' and 'net' are intended for usage with \link{cro} and
friends. 'tab_subtotal_*' and 'tab_net_*' are intended for usage with custom
tables - see \link{tables}.
}
\examples{
ol = c(1:7, 99)
var_lab(ol) = "Liking"
val_lab(ol)  = num_lab("
                     1 Disgusting
                     2 Very Poor
                     3 Poor
                     4 So-so
                     5 Good
                     6 Very good
                     7 Excellent
                     99 Hard to say
                     ")
                     
cro(subtotal(ol, TOP = 6:7, BOTTOM = 1:3, position = "top"))
# autolabelling
cro(subtotal(ol, 6:7, 1:3))
# replace original codes and another way of autolabelling
cro(net(ol, 6:7, 1:3, new_label = "range", prefix = "NET "))

# character variable and criteria usage
items = c("apple", "banana", "potato", "orange", "onion", "tomato", "pineapple")
cro(
    subtotal(items, 
             "TOTAL FRUITS"     = like("*ap*") | like("*an*"), 
             "TOTAL VEGETABLES" = like("*to*") | like("*on*"), 
             position = "bottom")
)

# 'tab_net_*' usage
data(mtcars)
mtcars = apply_labels(mtcars,
                      mpg = "Miles/(US) gallon",
                      am = "Transmission",
                      am = c("Automatic" = 0,
                             "Manual"=1),
                      gear = "Number of forward gears",
                      gear = c(
                          One = 1,
                          Two = 2,
                          Three = 3,
                          Four = 4,
                          Five = 5
                      )
)
mtcars \%>\% 
    tab_cells(mpg) \%>\% 
    tab_net_cells("Low mpg" = less(mean(mpg)), "High mpg" = greater_or_equal(mean(mpg))) \%>\% 
    tab_cols(total(), am) \%>\% 
    tab_stat_cases() \%>\% 
    tab_pivot()

mtcars \%>\% 
    tab_cells(mpg) \%>\% 
    tab_rows(gear) \%>\%
    tab_subtotal_rows(1:2, 3:4, "5 and more" = greater(4)) \%>\% 
    tab_stat_mean() \%>\% 
    tab_pivot()
}
