% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{var_lab}
\alias{var_lab}
\alias{var_lab<-}
\alias{set_var_lab}
\alias{unvr}
\alias{drop_var_labs}
\alias{add_labelled_class}
\title{Set or get variable label}
\usage{
var_lab(x)

var_lab(x) <- value

set_var_lab(x, value)

unvr(x)

drop_var_labs(x)

add_labelled_class(x, remove_classes = c("haven_labelled",
  "spss_labelled"))
}
\arguments{
\item{x}{Variable. In the most cases it is numeric vector.}

\item{value}{A character scalar - label for the variable x.}

\item{remove_classes}{A character vector of classes which should be removed
from the class attribute of the \code{x}.}
}
\value{
\code{var_lab} return variable label. If label doesn't exist it return
  NULL . \code{var_lab<-} and \code{set_var_lab} return variable (vector x)
  of class "labelled" with attribute "label" which equals submitted value.
}
\description{
These functions set/get/drop variable labels. For 
value labels see \link{val_lab}. For working with entire data.frame see
\link{apply_labels}.
\itemize{
\item{\code{var_lab}}{ returns variable label or NULL if label doesn't 
exist.} 
\item{\code{var_lab<-}}{ set variable label.} 
\item{\code{set_var_lab}}{ returns variable with label.}
\item{\code{unvr}}{ drops variable label.} 
\item{\code{add_labelled_class}}{ Add missing 'labelled' class. This function
is needed when you load SPSS data with packages which in some cases don't set
'labelled' class for variables with labels. For example, \code{haven} package
doesn't set 'labelled' class for variables which have variable label but
don't have value labels. Note that to use 'expss' with 'haven' you need to
load 'expss' strictly after 'haven' to avoid conflicts.} }
}
\details{
Variable label is stored in attribute "label" (\code{attr(x,"label")}). For
  preserving from dropping this attribute during some operations (such as \code{c})
  variable class is set to "labelled". There are special methods of
  subsetting and concatenation for this class. To drop variable label use 
  \code{var_lab(var) <- NULL} or \code{unvr(var)}.
}
\examples{
data(mtcars)
mtcars = modify(mtcars,{
                var_lab(mpg) = "Miles/(US) gallon"
                var_lab(cyl) = "Number of cylinders"
                var_lab(disp) = "Displacement (cu.in.)"
                var_lab(hp) = "Gross horsepower"
                var_lab(drat) = "Rear axle ratio"
                var_lab(wt) = "Weight (lb/1000)"
                var_lab(qsec) = "1/4 mile time"
                var_lab(vs) = "V/S"
                var_lab(am) = "Transmission (0 = automatic, 1 = manual)"
                val_lab(am) = c(automatic = 0, manual=1)
                var_lab(gear) = "Number of forward gears"
                var_lab(carb) = "Number of carburetors"
})

fre(mtcars$am)

calculate(mtcars, 
     cro_mean(list(mpg, disp, hp, qsec), list(total(), am))
     ) 

 
\dontrun{
# 'add_labelled_class' example doesn't work intentionally
if(FALSE){ # to prevent execution
# you need to load packages strictly in this order to avoid conflicts
library(haven)
library(expss)
spss_data = haven::read_spss("spss_file.sav")
# add missing 'labelled' class
spss_data = add_labelled_class(spss_data) 
}
}
}
