% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture-of-poisson-distributions.R
\name{PoissonMix}
\alias{PoissonMix}
\alias{dmixpois}
\alias{pmixpois}
\alias{rmixpois}
\title{Mixture of Poisson distributions}
\usage{
dmixpois(x, lambda, alpha, log = FALSE)

pmixpois(q, lambda, alpha, lower.tail = TRUE, log.p = FALSE)

rmixpois(n, lambda, alpha)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{matrix (or vector) of (non-negative) means.}

\item{alpha}{matrix (or vector) of mixing proportions;
mixing proportions need to sum up to 1.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}

\item{p}{vector of probabilities.}
}
\description{
Density, distribution function and random generation
for the mixture of Poisson distributions.
}
\details{
Probability density function
\deqn{
f(x) = \alpha_1 f_1(x; \lambda_1) + \dots + \alpha_k f_k(x; \lambda_k)
}{
f(x) = \alpha[1] * f1(x; \lambda[1]) + \dots + \alpha[k] * fk(x; \lambda[k])
}

Cumulative distribution function
\deqn{
F(x) = \alpha_1 F_1(x; \lambda_1) + \dots + \alpha_k F_k(x; \lambda_k)
}{
F(x) = \alpha[1] * F1(x; \lambda[1]) + \dots + \alpha[k] * Fk(x; \lambda[k])
}

where \eqn{\sum_i \alpha_i = 1}{sum(alpha[i]) == 1}.
}
\examples{

x <- rmixpois(1e5, c(5, 12, 19), c(1/3, 1/3, 1/3))
xx <- seq(-1, 50)
plot(prop.table(table(x)))
lines(xx, dmixpois(xx, c(5, 12, 19), c(1/3, 1/3, 1/3)), col = "red")
hist(pmixpois(x, c(5, 12, 19), c(1/3, 1/3, 1/3)))
plot(ecdf(x))
lines(xx, pmixpois(xx, c(5, 12, 19), c(1/3, 1/3, 1/3)), col = "red", lwd = 2)

}
\keyword{distribution}

