

test_that("Testing PDFs & PMFs against infinite values", {

  expect_true(!is.nan(dbetapr(Inf, 1, 1, 1)) && is.finite(dbetapr(Inf, 1, 1, 1)))
  expect_true(!is.nan(dbbinom(Inf, 10, 1, 1)) && is.finite(dbbinom(Inf, 10, 1, 1)))
  expect_true(!is.nan(dbnbinom(Inf, 10, 1, 1)) && is.finite(dbnbinom(Inf, 10, 1, 1)))
  expect_true(!is.nan(dbhatt(Inf)) && is.finite(dbhatt(Inf)))
  expect_true(!is.nan(dfatigue(Inf, 1)) && is.finite(dfatigue(Inf, 1)))
  expect_true(!is.nan(dcat(Inf, c(0.5, 0.5))) && is.finite(dcat(Inf, c(0.5, 0.5))))
  expect_true(!is.nan(ddlaplace(Inf, 0.5)) && is.finite(ddlaplace(Inf, 0.5)))
  expect_true(!is.nan(ddnorm(Inf)) && is.finite(ddnorm(Inf)))
  expect_true(!is.nan(ddweibull(Inf, 0.5, 1)) && is.finite(ddweibull(Inf, 0.5, 1)))  
  expect_true(!is.nan(dfrechet(Inf)) && is.finite(dfrechet(Inf)))
  expect_true(!is.nan(dgpois(Inf, 1, 1)) && is.finite(dgpois(Inf, 1, 1)))
  expect_true(!is.nan(dgev(Inf, 1, 1, 1)) && is.finite(dgev(Inf, 1, 1, 1)))
  expect_true(!is.nan(dgompertz(Inf, 1, 1)) && is.finite(dgompertz(Inf, 1, 1)))
  expect_true(!is.nan(dgpd(Inf, 1, 1, 1)) && is.finite(dgpd(Inf, 1, 1, 1)))
  expect_true(!is.nan(dgumbel(Inf)) && is.finite(dgumbel(Inf)))
  expect_true(!is.nan(dhuber(Inf)) && is.finite(dhuber(Inf)))
  expect_true(!is.nan(dhcauchy(Inf, 1)) && is.finite(dhcauchy(Inf, 1)))
  expect_true(!is.nan(dhnorm(Inf, 1)) && is.finite(dhnorm(Inf, 1)))
  expect_true(!is.nan(dht(Inf, 5, 1)) && is.finite(dht(Inf, 5, 1)))
  expect_true(!is.nan(dinvgamma(Inf, 1, 1)) && is.finite(dinvgamma(Inf, 1, 1)))
  expect_true(!is.nan(dlaplace(Inf)) && is.finite(dlaplace(Inf)))
  expect_true(!is.nan(dlgser(Inf, 0.5)) && is.finite(dlgser(Inf, 0.5)))
  expect_true(!is.nan(dlomax(Inf, 1, 1)) && is.finite(dlomax(Inf, 1, 1)))
  expect_true(!is.nan(dmixnorm(Inf, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3))) && is.finite(dmixnorm(Inf, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3))))
  expect_true(!is.nan(dmixpois(Inf, c(1,2,3), c(1/3,1/3,1/3))) && is.finite(dmixpois(Inf, c(1,2,3), c(1/3,1/3,1/3))))
  expect_true(!is.nan(dnst(Inf, df = 2)) && is.finite(dnst(Inf, df = 2)))
  expect_true(!is.nan(dpareto(Inf)) && is.finite(dpareto(Inf)))
  expect_true(!is.nan(dpower(Inf, 1, 1)) && is.finite(dpower(Inf, 1, 1)))
  expect_true(!is.nan(dprop(Inf, 10, 0.5)) && is.finite(dprop(Inf, 10, 0.5)))
  expect_true(!is.nan(drayleigh(Inf)) && is.finite(drayleigh(Inf)))
  expect_true(!is.nan(dslash(Inf)) && is.finite(dslash(Inf)))
  expect_true(!is.nan(dtpois(Inf, lambda = 5)) && is.finite(dtpois(Inf, lambda = 5)))
  expect_true(!is.nan(dtpois(Inf, lambda = 5, s = 6)) && is.finite(dtpois(Inf, lambda = 5, s = 6)))
  expect_true(!is.nan(dwald(Inf, 1, 1)) && is.finite(dwald(Inf, 1, 1)))
  expect_true(!is.nan(dzip(Inf, 1, 0.5)) && is.finite(dzip(Inf, 1, 0.5)))
  expect_true(!is.nan(dzib(Inf, 1, 1, 0.5)) && is.finite(dzinb(Inf, 1, 1, 0.5)))
  expect_true(!is.nan(dzinb(Inf, 1, 1, 0.5)) && is.finite(dzinb(Inf, 1, 1, 0.5)))

})


test_that("Testing CDFs against infinite values", {
  
  expect_true(!is.nan(pbetapr(Inf, 1, 1, 1)) && is.finite(pbetapr(Inf, 1, 1, 1)))
  expect_true(!is.nan(pbbinom(Inf, 10, 1, 1)) && is.finite(pbbinom(Inf, 10, 1, 1)))
  expect_true(!is.nan(pbnbinom(Inf, 10, 1, 1)) && is.finite(pbnbinom(Inf, 10, 1, 1)))
  expect_true(!is.nan(pbhatt(Inf)) && is.finite(pbhatt(Inf)))
  expect_true(!is.nan(pfatigue(Inf, 1)) && is.finite(pfatigue(Inf, 1)))
  expect_true(!is.nan(pcat(Inf, c(0.5, 0.5))) && is.finite(pcat(Inf, c(0.5, 0.5))))
  expect_true(!is.nan(pdlaplace(Inf, 0.5)) && is.finite(pdlaplace(Inf, 0.5)))
  expect_true(!is.nan(pdnorm(Inf)) && is.finite(pdnorm(Inf)))
  expect_true(!is.nan(pdweibull(Inf, 0.5, 1)) && is.finite(pdweibull(Inf, 0.5, 1)))  
  expect_true(!is.nan(pfrechet(Inf)) && is.finite(pfrechet(Inf)))
  expect_true(!is.nan(pgpois(Inf, 1, 1)) && is.finite(pgpois(Inf, 1, 1)))
  expect_true(!is.nan(pgev(Inf, 1, 1, 1)) && is.finite(pgev(Inf, 1, 1, 1)))
  expect_true(!is.nan(pgompertz(Inf, 1, 1)) && is.finite(pgompertz(Inf, 1, 1)))
  expect_true(!is.nan(pgpd(Inf, 1, 1, 1)) && is.finite(pgpd(Inf, 1, 1, 1)))
  expect_true(!is.nan(pgumbel(Inf)) && is.finite(pgumbel(Inf)))
  expect_true(!is.nan(phuber(Inf)) && is.finite(phuber(Inf)))
  expect_true(!is.nan(phcauchy(Inf, 1)) && is.finite(phcauchy(Inf, 1)))
  expect_true(!is.nan(phnorm(Inf, 1)) && is.finite(phnorm(Inf, 1)))
  expect_true(!is.nan(pht(Inf, 5, 1)) && is.finite(pht(Inf, 5, 1)))
  expect_true(!is.nan(pinvgamma(Inf, 1, 1)) && is.finite(pinvgamma(Inf, 1, 1)))
  expect_true(!is.nan(plaplace(Inf)) && is.finite(plaplace(Inf)))
  expect_true(!is.nan(plgser(Inf, 0.5)) && is.finite(plgser(Inf, 0.5)))
  expect_true(!is.nan(plomax(Inf, 1, 1)) && is.finite(plomax(Inf, 1, 1)))
  expect_true(!is.nan(pmixnorm(Inf, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3))) && is.finite(pmixnorm(Inf, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3))))
  expect_true(!is.nan(pmixpois(Inf, c(1,2,3), c(1/3,1/3,1/3))) && is.finite(pmixpois(Inf, c(1,2,3), c(1/3,1/3,1/3))))
  expect_true(!is.nan(pnst(Inf, df = 2)) && is.finite(pnst(Inf, df = 2)))
  expect_true(!is.nan(ppareto(Inf)) && is.finite(ppareto(Inf)))
  expect_true(!is.nan(ppower(Inf, 1, 1)) && is.finite(ppower(Inf, 1, 1)))
  expect_true(!is.nan(pprop(Inf, 10, 0.5)) && is.finite(pprop(Inf, 10, 0.5)))
  expect_true(!is.nan(prayleigh(Inf)) && is.finite(prayleigh(Inf)))
  expect_true(!is.nan(pslash(Inf)) && is.finite(pslash(Inf)))
  expect_true(!is.nan(ptpois(Inf, lambda = 5)) && is.finite(ptpois(Inf, lambda = 5)))
  expect_true(!is.nan(ptpois(Inf, lambda = 5, s = 6)) && is.finite(ptpois(Inf, lambda = 5, s = 6)))
  expect_true(!is.nan(pwald(Inf, 1, 1)) && is.finite(pwald(Inf, 1, 1)))
  expect_true(!is.nan(pzip(Inf, 1, 0.5)) && is.finite(pzip(Inf, 1, 0.5)))
  expect_true(!is.nan(pzib(Inf, 1, 1, 0.5)) && is.finite(pzinb(Inf, 1, 1, 0.5)))
  expect_true(!is.nan(pzinb(Inf, 1, 1, 0.5)) && is.finite(pzinb(Inf, 1, 1, 0.5)))
  
})




test_that("Testing PDFs & PMFs against negatively infinite values", {
  
  expect_true(!is.nan(dbetapr(-Inf, 1, 1, 1)) && is.finite(dbetapr(-Inf, 1, 1, 1)))
  expect_true(!is.nan(dbbinom(-Inf, 10, 1, 1)) && is.finite(dbbinom(-Inf, 10, 1, 1)))
  expect_true(!is.nan(dbnbinom(-Inf, 10, 1, 1)) && is.finite(dbnbinom(-Inf, 10, 1, 1)))
  expect_true(!is.nan(dbhatt(-Inf)) && is.finite(dbhatt(-Inf)))
  expect_true(!is.nan(dfatigue(-Inf, 1)) && is.finite(dfatigue(-Inf, 1)))
  expect_true(!is.nan(dcat(-Inf, c(0.5, 0.5))) && is.finite(dcat(-Inf, c(0.5, 0.5))))
  expect_true(!is.nan(ddlaplace(-Inf, 0.5)) && is.finite(ddlaplace(-Inf, 0.5)))
  expect_true(!is.nan(ddnorm(-Inf)) && is.finite(ddnorm(-Inf)))
  expect_true(!is.nan(ddweibull(-Inf, 0.5, 1)) && is.finite(ddweibull(-Inf, 0.5, 1)))  
  expect_true(!is.nan(dfrechet(-Inf)) && is.finite(dfrechet(-Inf)))
  expect_true(!is.nan(dgpois(-Inf, 1, 1)) && is.finite(dgpois(-Inf, 1, 1)))
  expect_true(!is.nan(dgev(-Inf, 1, 1, 1)) && is.finite(dgev(-Inf, 1, 1, 1)))
  expect_true(!is.nan(dgompertz(-Inf, 1, 1)) && is.finite(dgompertz(-Inf, 1, 1)))
  expect_true(!is.nan(dgpd(-Inf, 1, 1, 1)) && is.finite(dgpd(-Inf, 1, 1, 1)))
  expect_true(!is.nan(dgumbel(-Inf)) && is.finite(dgumbel(-Inf)))
  expect_true(!is.nan(dhuber(-Inf)) && is.finite(dhuber(-Inf)))
  expect_true(!is.nan(dhcauchy(-Inf, 1)) && is.finite(dhcauchy(-Inf, 1)))
  expect_true(!is.nan(dhnorm(-Inf, 1)) && is.finite(dhnorm(-Inf, 1)))
  expect_true(!is.nan(dht(-Inf, 5, 1)) && is.finite(dht(-Inf, 5, 1)))
  expect_true(!is.nan(dinvgamma(-Inf, 1, 1)) && is.finite(dinvgamma(-Inf, 1, 1)))
  expect_true(!is.nan(dlaplace(-Inf)) && is.finite(dlaplace(-Inf)))
  expect_true(!is.nan(dlgser(-Inf, 0.5)) && is.finite(dlgser(-Inf, 0.5)))
  expect_true(!is.nan(dlomax(-Inf, 1, 1)) && is.finite(dlomax(-Inf, 1, 1)))
  expect_true(!is.nan(dmixnorm(-Inf, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3))) && is.finite(dmixnorm(-Inf, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3))))
  expect_true(!is.nan(dmixpois(-Inf, c(1,2,3), c(1/3,1/3,1/3))) && is.finite(dmixpois(-Inf, c(1,2,3), c(1/3,1/3,1/3))))
  expect_true(!is.nan(dnst(-Inf, df = 2)) && is.finite(dnst(-Inf, df = 2)))
  expect_true(!is.nan(dpareto(-Inf)) && is.finite(dpareto(-Inf)))
  expect_true(!is.nan(dpower(-Inf, 1, 1)) && is.finite(dpower(-Inf, 1, 1)))
  expect_true(!is.nan(dprop(-Inf, 10, 0.5)) && is.finite(dprop(-Inf, 10, 0.5)))
  expect_true(!is.nan(drayleigh(-Inf)) && is.finite(drayleigh(-Inf)))
  expect_true(!is.nan(dslash(-Inf)) && is.finite(dslash(-Inf)))
  expect_true(!is.nan(dtpois(-Inf, lambda = 5)) && is.finite(dtpois(-Inf, lambda = 5)))
  expect_true(!is.nan(dtpois(-Inf, lambda = 5, s = 6)) && is.finite(dtpois(-Inf, lambda = 5, s = 6)))
  expect_true(!is.nan(dwald(-Inf, 1, 1)) && is.finite(dwald(-Inf, 1, 1)))
  expect_true(!is.nan(dzip(-Inf, 1, 0.5)) && is.finite(dzip(-Inf, 1, 0.5)))
  expect_true(!is.nan(dzib(-Inf, 1, 1, 0.5)) && is.finite(dzinb(-Inf, 1, 1, 0.5)))
  expect_true(!is.nan(dzinb(-Inf, 1, 1, 0.5)) && is.finite(dzinb(-Inf, 1, 1, 0.5)))
  
})


test_that("Testing CDFs against negatively infinite values", {
  
  expect_true(!is.nan(pbetapr(-Inf, 1, 1, 1)) && is.finite(pbetapr(-Inf, 1, 1, 1)))
  expect_true(!is.nan(pbbinom(-Inf, 10, 1, 1)) && is.finite(pbbinom(-Inf, 10, 1, 1)))
  expect_true(!is.nan(pbnbinom(-Inf, 10, 1, 1)) && is.finite(pbnbinom(-Inf, 10, 1, 1)))
  expect_true(!is.nan(pbhatt(-Inf)) && is.finite(pbhatt(-Inf)))
  expect_true(!is.nan(pfatigue(-Inf, 1)) && is.finite(pfatigue(-Inf, 1)))
  expect_true(!is.nan(pcat(-Inf, c(0.5, 0.5))) && is.finite(pcat(-Inf, c(0.5, 0.5))))
  expect_true(!is.nan(pdlaplace(-Inf, 0.5)) && is.finite(pdlaplace(-Inf, 0.5)))
  expect_true(!is.nan(pdnorm(-Inf)) && is.finite(pdnorm(-Inf)))
  expect_true(!is.nan(pdweibull(-Inf, 0.5, 1)) && is.finite(pdweibull(-Inf, 0.5, 1)))  
  expect_true(!is.nan(pfrechet(-Inf)) && is.finite(pfrechet(-Inf)))
  expect_true(!is.nan(pgpois(-Inf, 1, 1)) && is.finite(pgpois(-Inf, 1, 1)))
  expect_true(!is.nan(pgev(-Inf, 1, 1, 1)) && is.finite(pgev(-Inf, 1, 1, 1)))
  expect_true(!is.nan(pgompertz(-Inf, 1, 1)) && is.finite(pgompertz(-Inf, 1, 1)))
  expect_true(!is.nan(pgpd(-Inf, 1, 1, 1)) && is.finite(pgpd(-Inf, 1, 1, 1)))
  expect_true(!is.nan(pgumbel(-Inf)) && is.finite(pgumbel(-Inf)))
  expect_true(!is.nan(phuber(-Inf)) && is.finite(phuber(-Inf)))
  expect_true(!is.nan(phcauchy(-Inf, 1)) && is.finite(phcauchy(-Inf, 1)))
  expect_true(!is.nan(phnorm(-Inf, 1)) && is.finite(phnorm(-Inf, 1)))
  expect_true(!is.nan(pht(-Inf, 5, 1)) && is.finite(pht(-Inf, 5, 1)))
  expect_true(!is.nan(pinvgamma(-Inf, 1, 1)) && is.finite(pinvgamma(-Inf, 1, 1)))
  expect_true(!is.nan(plaplace(-Inf)) && is.finite(plaplace(-Inf)))
  expect_true(!is.nan(plgser(-Inf, 0.5)) && is.finite(plgser(-Inf, 0.5)))
  expect_true(!is.nan(plomax(-Inf, 1, 1)) && is.finite(plomax(-Inf, 1, 1)))
  expect_true(!is.nan(pmixnorm(-Inf, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3))) && is.finite(pmixnorm(-Inf, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3))))
  expect_true(!is.nan(pmixpois(-Inf, c(1,2,3), c(1/3,1/3,1/3))) && is.finite(pmixpois(-Inf, c(1,2,3), c(1/3,1/3,1/3))))
  expect_true(!is.nan(pnst(-Inf, df = 2)) && is.finite(pnst(-Inf, df = 2)))
  expect_true(!is.nan(ppareto(-Inf)) && is.finite(ppareto(-Inf)))
  expect_true(!is.nan(ppower(-Inf, 1, 1)) && is.finite(ppower(-Inf, 1, 1)))
  expect_true(!is.nan(pprop(-Inf, 10, 0.5)) && is.finite(pprop(-Inf, 10, 0.5)))
  expect_true(!is.nan(prayleigh(-Inf)) && is.finite(prayleigh(-Inf)))
  expect_true(!is.nan(pslash(-Inf)) && is.finite(pslash(-Inf)))
  expect_true(!is.nan(ptpois(-Inf, lambda = 5)) && is.finite(ptpois(-Inf, lambda = 5)))
  expect_true(!is.nan(ptpois(-Inf, lambda = 5, s = 6)) && is.finite(ptpois(-Inf, lambda = 5, s = 6)))
  expect_true(!is.nan(pwald(-Inf, 1, 1)) && is.finite(pwald(-Inf, 1, 1)))
  expect_true(!is.nan(pzip(-Inf, 1, 0.5)) && is.finite(pzip(-Inf, 1, 0.5)))
  expect_true(!is.nan(pzib(-Inf, 1, 1, 0.5)) && is.finite(pzinb(-Inf, 1, 1, 0.5)))
  expect_true(!is.nan(pzinb(-Inf, 1, 1, 0.5)) && is.finite(pzinb(-Inf, 1, 1, 0.5)))
  
})



